/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CgGL;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.j3d.Context;
import javax.media.j3d.JoglCgShaderProgramInfo;
import javax.media.j3d.JoglShaderObject;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

class JoglContext
implements Context {
    private GLContext context;
    private int maxTexCoordSets;
    private float alphaClearValue;
    private int currentTextureUnit;
    private int currentCombinerUnit;
    private boolean hasMultisample;
    private JoglShaderObject shaderProgram;
    private VertexAttributeImpl vertexAttrImpl;
    private int glslVertexAttrOffset;
    private CGcontext cgContext;
    private int cgVertexProfile;
    private int cgFragmentProfile;

    JoglContext(GLContext gLContext) {
        this.context = gLContext;
    }

    GLContext getGLContext() {
        return this.context;
    }

    int getMaxTexCoordSets() {
        return this.maxTexCoordSets;
    }

    void setMaxTexCoordSets(int n) {
        this.maxTexCoordSets = n;
    }

    float getAlphaClearValue() {
        return this.alphaClearValue;
    }

    void setAlphaClearValue(float f) {
        this.alphaClearValue = f;
    }

    int getCurrentTextureUnit() {
        return this.currentTextureUnit;
    }

    void setCurrentTextureUnit(int n) {
        this.currentTextureUnit = n;
    }

    int getCurrentCombinerUnit() {
        return this.currentCombinerUnit;
    }

    void setCurrentCombinerUnit(int n) {
        this.currentCombinerUnit = n;
    }

    boolean getHasMultisample() {
        return this.hasMultisample;
    }

    void setHasMultisample(boolean bl) {
        this.hasMultisample = bl;
    }

    void initCgVertexAttributeImpl() {
        if (this.vertexAttrImpl != null) {
            throw new RuntimeException("Should not initialize the vertex attribute implementation twice");
        }
        this.vertexAttrImpl = new CgVertexAttributeImpl();
    }

    void initGLSLVertexAttributeImpl() {
        if (this.vertexAttrImpl != null) {
            throw new RuntimeException("Should not initialize the vertex attribute implementation twice");
        }
        this.vertexAttrImpl = new GLSLVertexAttributeImpl();
    }

    void vertexAttrPointer(GL gL, int n, int n2, int n3, int n4, Buffer buffer) {
        this.vertexAttrImpl.vertexAttrPointer(gL, n, n2, n3, n4, buffer);
    }

    void enableVertexAttrArray(GL gL, int n) {
        this.vertexAttrImpl.enableVertexAttrArray(gL, n);
    }

    void disableVertexAttrArray(GL gL, int n) {
        this.vertexAttrImpl.disableVertexAttrArray(gL, n);
    }

    void vertexAttr1fv(GL gL, int n, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr1fv(gL, n, floatBuffer);
    }

    void vertexAttr2fv(GL gL, int n, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr2fv(gL, n, floatBuffer);
    }

    void vertexAttr3fv(GL gL, int n, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr3fv(gL, n, floatBuffer);
    }

    void vertexAttr4fv(GL gL, int n, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr4fv(gL, n, floatBuffer);
    }

    JoglShaderObject getShaderProgram() {
        return this.shaderProgram;
    }

    void setShaderProgram(JoglShaderObject joglShaderObject) {
        this.shaderProgram = joglShaderObject;
    }

    int getGLSLVertexAttrOffset() {
        return this.glslVertexAttrOffset;
    }

    void setGLSLVertexAttrOffset(int n) {
        this.glslVertexAttrOffset = n;
    }

    CGcontext getCgContext() {
        return this.cgContext;
    }

    void setCgContext(CGcontext cGcontext) {
        this.cgContext = cGcontext;
    }

    int getCgVertexProfile() {
        return this.cgVertexProfile;
    }

    void setCgVertexProfile(int n) {
        this.cgVertexProfile = n;
    }

    int getCgFragmentProfile() {
        return this.cgFragmentProfile;
    }

    void setCgFragmentProfile(int n) {
        this.cgFragmentProfile = n;
    }

    class GLSLVertexAttributeImpl
    implements VertexAttributeImpl {
        GLSLVertexAttributeImpl() {
        }

        public void vertexAttrPointer(GL gL, int n, int n2, int n3, int n4, Buffer buffer) {
            gL.glVertexAttribPointerARB(n + JoglContext.this.glslVertexAttrOffset, n2, n3, false, n4, buffer);
        }

        public void enableVertexAttrArray(GL gL, int n) {
            gL.glEnableVertexAttribArrayARB(n + JoglContext.this.glslVertexAttrOffset);
        }

        public void disableVertexAttrArray(GL gL, int n) {
            gL.glDisableVertexAttribArrayARB(n + JoglContext.this.glslVertexAttrOffset);
        }

        public void vertexAttr1fv(GL gL, int n, FloatBuffer floatBuffer) {
            gL.glVertexAttrib1fvARB(n + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr2fv(GL gL, int n, FloatBuffer floatBuffer) {
            gL.glVertexAttrib2fvARB(n + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr3fv(GL gL, int n, FloatBuffer floatBuffer) {
            gL.glVertexAttrib3fvARB(n + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr4fv(GL gL, int n, FloatBuffer floatBuffer) {
            gL.glVertexAttrib4fvARB(n + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }
    }

    class CgVertexAttributeImpl
    implements VertexAttributeImpl {
        CgVertexAttributeImpl() {
        }

        public void vertexAttrPointer(GL gL, int n, int n2, int n3, int n4, Buffer buffer) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLSetParameterPointer((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n], (int)n2, (int)n3, (int)n4, (Buffer)buffer);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void enableVertexAttrArray(GL gL, int n) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLEnableClientState((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n]);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void disableVertexAttrArray(GL gL, int n) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLDisableClientState((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n]);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void vertexAttr1fv(GL gL, int n, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr1fv");
        }

        public void vertexAttr2fv(GL gL, int n, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr2fv");
        }

        public void vertexAttr3fv(GL gL, int n, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr3fv");
        }

        public void vertexAttr4fv(GL gL, int n, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr4fv");
        }
    }

    static interface VertexAttributeImpl {
        public void vertexAttrPointer(GL var1, int var2, int var3, int var4, int var5, Buffer var6);

        public void enableVertexAttrArray(GL var1, int var2);

        public void disableVertexAttrArray(GL var1, int var2);

        public void vertexAttr1fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr2fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr3fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr4fv(GL var1, int var2, FloatBuffer var3);
    }
}

