/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class FilterConsumer
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.index.rtree");
    private Envelope bounds = null;

    public Envelope getBounds() {
        return this.bounds;
    }

    public void visit(Filter filter) {
        if (filter.getFilterType() == Filter.NONE.getFilterType()) {
            this.bounds = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else if (filter.getFilterType() == Filter.ALL.getFilterType()) {
            this.bounds = null;
        } else {
            LOGGER.warning("Unknown filter type:" + filter.toString());
        }
    }

    public void visit(BetweenFilter filter) {
        LOGGER.finest("BetweenFilter ignored!");
    }

    public void visit(CompareFilter filter) {
        LOGGER.finest("CompareFilter ignored!");
    }

    public void visit(GeometryFilter filter) {
        if (filter.getFilterType() == 4 || filter.getFilterType() == 5 || filter.getFilterType() == 7 || filter.getFilterType() == 8 || filter.getFilterType() == 9 || filter.getFilterType() == 10 || filter.getFilterType() == 11 || filter.getFilterType() == 12 || filter.getFilterType() == 24) {
            DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
            DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
            if (left != null) {
                left.accept((FilterVisitor)this);
            }
            if (right != null) {
                right.accept((FilterVisitor)this);
            }
        }
    }

    public void visit(LikeFilter filter) {
        LOGGER.finest("LikeFilter ignored!");
    }

    public void visit(LogicFilter filter) {
        switch (filter.getFilterType()) {
            case 3: {
                LOGGER.finest("[NOT] LogicFilter ignored!");
                break;
            }
            case 1: {
                LOGGER.finest("[OR] LogicFilter ignored!");
                break;
            }
            case 2: {
                Iterator list = filter.getFilterIterator();
                while (list.hasNext()) {
                    ((AbstractFilter)list.next()).accept((FilterVisitor)this);
                }
                break;
            }
            default: {
                LOGGER.finest("LogicFilter ignored!");
            }
        }
    }

    public void visit(NullFilter filter) {
        LOGGER.finest("NullFilter ignored!");
    }

    public void visit(FidFilter filter) {
        LOGGER.finest("FidFilter ignored!");
    }

    public void visit(AttributeExpression expression) {
        LOGGER.finest("AttributeExpression ignored!");
    }

    public void visit(Expression expression) {
        LOGGER.finest("Expression ignored!");
    }

    public void visit(LiteralExpression expression) {
        if (expression.getType() == 104) {
            Geometry bbox = (Geometry)expression.getLiteral();
            if (this.bounds == null) {
                this.bounds = bbox.getEnvelopeInternal();
            } else {
                this.bounds.expandToInclude(bbox.getEnvelopeInternal());
            }
        } else {
            LOGGER.warning("LiteralExpression ignored!");
        }
    }

    public void visit(MathExpression expression) {
        LOGGER.finest("MathExpression ignored!");
    }

    public void visit(FunctionExpression expression) {
        LOGGER.finest("FunctionExpression ignored!");
    }
}

