/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.TransformedAuthorityFactory;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class OrderedAxisAuthorityFactory
extends TransformedAuthorityFactory
implements CSAuthorityFactory,
CRSAuthorityFactory,
Comparator {
    private static final AxisDirection[] DEFAULT_ORDER = new AxisDirection[]{AxisDirection.EAST, AxisDirection.EAST_NORTH_EAST, AxisDirection.NORTH_EAST, AxisDirection.NORTH_NORTH_EAST, AxisDirection.NORTH, AxisDirection.UP, AxisDirection.GEOCENTRIC_X, AxisDirection.GEOCENTRIC_Y, AxisDirection.GEOCENTRIC_Z, AxisDirection.COLUMN_POSITIVE, AxisDirection.ROW_POSITIVE, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_UP, AxisDirection.FUTURE};
    private static final Map REGISTERED = new HashMap();
    private final int[] directionRanks;
    protected final boolean forceStandardDirections;
    protected final boolean forceStandardUnits;

    public OrderedAxisAuthorityFactory(String authority, Hints hints, AxisDirection[] axisOrder) throws FactoryRegistryException, IllegalArgumentException {
        super(authority, hints);
        this.forceStandardUnits = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisAuthorityFactory.computeDirectionRanks(axisOrder);
        this.completeHints();
    }

    public OrderedAxisAuthorityFactory(AbstractAuthorityFactory factory, Hints hints, AxisDirection[] axisOrder) throws IllegalArgumentException {
        super(factory);
        this.forceStandardUnits = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_UNITS);
        this.forceStandardDirections = OrderedAxisAuthorityFactory.booleanValue(hints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.directionRanks = OrderedAxisAuthorityFactory.computeDirectionRanks(axisOrder);
        this.completeHints();
    }

    public OrderedAxisAuthorityFactory(String authority, Hints hints, boolean forceStandardUnits) {
        this(authority, OrderedAxisAuthorityFactory.mergeHints(hints, forceStandardUnits), null);
    }

    public OrderedAxisAuthorityFactory(AbstractAuthorityFactory factory, boolean forceStandardUnits) {
        this(factory, OrderedAxisAuthorityFactory.mergeHints(null, forceStandardUnits), null);
    }

    private static Hints mergeHints(Hints hints, boolean forceStandardUnits) {
        hints = new Hints((Map)hints);
        hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, (Object)forceStandardUnits);
        return hints;
    }

    private static boolean booleanValue(Hints hints, Hints.Key key) {
        Boolean value;
        if (hints != null && (value = (Boolean)hints.get(key)) != null) {
            return value;
        }
        return false;
    }

    private void completeHints() {
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, this.forceStandardUnits);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, this.forceStandardDirections);
        if (this.compare(DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.NORTHING) < 0) {
            this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String authority) throws FactoryRegistryException {
        authority = authority.toUpperCase().trim();
        Map map = REGISTERED;
        synchronized (map) {
            if (REGISTERED.containsKey(authority)) {
                return;
            }
            OrderedAxisAuthorityFactory candidate = new OrderedAxisAuthorityFactory(authority, null, false);
            FactoryFinder.addAuthorityFactory(candidate);
            if (REGISTERED.put(authority, candidate) != null) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String authority) throws FactoryRegistryException {
        authority = authority.toUpperCase().trim();
        Map map = REGISTERED;
        synchronized (map) {
            AbstractAuthorityFactory candidate = (AbstractAuthorityFactory)REGISTERED.remove(authority);
            if (candidate != null) {
                FactoryFinder.removeAuthorityFactory(candidate);
            }
        }
    }

    private static int[] computeDirectionRanks(AxisDirection[] axisOrder) throws IllegalArgumentException {
        if (axisOrder == null) {
            axisOrder = DEFAULT_ORDER;
        }
        int length = 0;
        for (int i = 0; i < axisOrder.length; ++i) {
            int ordinal = axisOrder[i].absolute().ordinal() + 1;
            if (ordinal <= length) continue;
            length = ordinal;
        }
        int[] directionRanks = new int[length];
        Arrays.fill(directionRanks, length);
        int i = 0;
        while (i < axisOrder.length) {
            int ordinal = axisOrder[i].absolute().ordinal();
            int previous = directionRanks[ordinal];
            if (previous != length) {
                throw new IllegalArgumentException(Errors.format(27, axisOrder[previous].name(), axisOrder[i].name()));
            }
            directionRanks[ordinal] = i++;
        }
        return directionRanks;
    }

    private final int rank(CoordinateSystemAxis axis) {
        int c = axis.getDirection().absolute().ordinal();
        c = c >= 0 && c < this.directionRanks.length ? this.directionRanks[c] : this.directionRanks.length;
        return c;
    }

    public int compare(Object axis1, Object axis2) {
        return this.rank((CoordinateSystemAxis)axis1) - this.rank((CoordinateSystemAxis)axis2);
    }

    protected Unit replace(Unit units) {
        if (this.forceStandardUnits) {
            if (units.isCompatible((Unit)SI.METER)) {
                return SI.METER;
            }
            if (units.equals((Object)SI.RADIAN) || units.equals((Object)NonSI.GRADE)) {
                return NonSI.DEGREE_ANGLE;
            }
        }
        return units;
    }

    protected AxisDirection replace(AxisDirection direction) {
        return this.forceStandardDirections ? direction.absolute() : direction;
    }

    private static final String getErrorMessage(CoordinateSystem cs) {
        return Errors.format(151, cs.getName().getCode());
    }
}

