/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;

public class AbstractDataStore2
implements DataStore {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    private InProcessLockingManager lockingManager = this.createLockingManager();
    private List contents = null;

    protected InProcessLockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public List entries() {
        if (this.contents == null) {
            this.contents = this.createContents();
        }
        return Collections.unmodifiableList(this.contents);
    }

    protected List createContents() {
        throw new UnsupportedOperationException("createContent not implemented");
    }

    public String[] getTypeNames() {
        List all = this.entries();
        String[] names = new String[all.size()];
        int index = 0;
        Iterator i = all.iterator();
        while (i.hasNext()) {
            ActiveTypeEntry entry = (ActiveTypeEntry)i.next();
            names[index] = entry.getTypeName();
            ++index;
        }
        return names;
    }

    public ActiveTypeEntry entry(String typeName) {
        if (typeName == null) {
            return null;
        }
        Iterator i = this.entries().iterator();
        while (i.hasNext()) {
            ActiveTypeEntry entry = (ActiveTypeEntry)i.next();
            if (!typeName.equals(entry.getTypeName())) continue;
            return entry;
        }
        return null;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        return this.entry(typeName).getSchema();
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        return this.entry(typeName).getFeatureSource();
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        String typeName = query.getTypeName();
        return this.entry(typeName).reader(query, transaction);
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (filter == Filter.ALL) {
            FeatureType featureType = this.getSchema(typeName);
            return new EmptyFeatureWriter(featureType);
        }
        FeatureWriter writer = this.getFeatureWriter(typeName, transaction);
        if (filter != Filter.NONE) {
            writer = new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.entry(typeName).writer(transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.entry(typeName).createAppend(transaction);
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }
}

