/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcDailyNetRadiation_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean temperature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable relative humidity")
    public JAMSDouble rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable albedo")
    public JAMSDouble albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute elevation")
    public JAMSDouble elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily net radiation [MJ/m\u00b2]")
    public JAMSDouble netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily shortwave radiation [MJ/m\u00b2]")
    public JAMSDouble swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily longwave radiation [MJ/m\u00b2]")
    public JAMSDouble lwRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily net radiation for refET [MJ/m\u00b2]")
    public JAMSDouble refETNetRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        double elev = this.elevation.getValue();
        double temp = this.tmean.getValue();
        double rh = this.rhum.getValue();
        double sR = this.solRad.getValue();
        double alb = this.albedo.getValue();
        double extraTerrestialRad = this.extRad.getValue();
        double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temp);
        double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
        double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraTerrestialRad);
        double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sR);
        double netRefETSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(0.23, sR);
        double netLWRadiation = DailySolarRadiationCalculationMethods.calc_DailyNetLongwaveRadiation(temp, act_vapour_pressure, sR, clearSkyRad, false);
        double nR_norm = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
        double nR_refET = SolarRadiationCalculationMethods.calc_NetRadiation(netRefETSWRadiation, netLWRadiation);
        this.netRad.setValue(nR_norm);
        this.refETNetRad.setValue(nR_refET);
        this.swRad.setValue(netSWRadiation);
        this.lwRad.setValue(netLWRadiation);
    }

    public void cleanup() throws IOException {
    }
}

