/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="RainCorrectionRichterMonthly", author="Peter Krause", description="Applies correction according to RICHTER 1985 for measured monthly precip sums")
public class RainCorrectionRichterMonthly
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the uncorrected precip values")
    public JAMSDoubleArray inPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="the corrected precip values")
    public JAMSDoubleArray corrPrecip;
    double NODATA = -9999.0;
    double[] richter3_b = new double[]{0.233, 0.245, 0.203, 0.151, 0.111, 0.098, 0.1, 0.095, 0.115, 0.127, 0.168, 0.198};
    double[] richter3_c = new double[]{0.173, 0.179, 0.155, 0.127, 0.101, 0.088, 0.091, 0.085, 0.102, 0.11, 0.133, 0.15};

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double[] corrFactor = this.richter3_c;
        double[] precip = this.inPrecip.getValue();
        double[] rcorr = new double[precip.length];
        int month = this.time.get(2);
        for (int i = 0; i < rcorr.length; ++i) {
            rcorr[i] = precip[i] == -9999.0 ? -9999.0 : precip[i] + precip[i] * corrFactor[month];
        }
        this.corrPrecip.setValue(rcorr);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

