/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class J2KReservoirModule
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The receiver reach ID")
    public JAMSDouble outReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="data array read from file")
    public JAMSDoubleArray inDataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="var names in data array")
    public JAMSStringArray inDataNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the outflow from the data file or another model")
    public JAMSDouble resOutflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the reservoir area read in from file")
    public JAMSDouble resArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the reservoir volume read in from file")
    public JAMSDouble resObsVolume;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the calculated reservoir volume")
    public JAMSDouble resCalcVolume;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the reservoir depth read in from file")
    public JAMSDouble resDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="component RD1")
    public JAMSDouble compRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="component RD2")
    public JAMSDouble compRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="component RG1")
    public JAMSDouble compRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="component RG2")
    public JAMSDouble compRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow RD1")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow RD2")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow RG1")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="outflow RG2")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the precipitation")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the potential et")
    public JAMSDouble pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the actual et")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="startVolume")
    public JAMSDouble startVolume;
    int nComp = 4;
    double[] relComp;
    double[] runComp;
    double[] outComp;
    JAMSEntity recReach = null;
    double currVolume = 0.0;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.relComp = new double[this.nComp];
        this.runComp = new double[this.nComp];
        this.outComp = new double[this.nComp];
        this.resCalcVolume.setValue(this.startVolume.getValue());
        this.compRD1.setValue(this.startVolume.getValue() * 0.1);
        this.compRD1.setValue(this.startVolume.getValue() * 0.3);
        this.compRD1.setValue(this.startVolume.getValue() * 0.3);
        this.compRD1.setValue(this.startVolume.getValue() * 0.3);
        int nEnts = this.reaches.getEntityArray().length;
        for (int i = 0; i < nEnts; ++i) {
            if (this.reaches.getEntityArray()[i].getDouble("ID") != this.getContext().getEntities().getCurrent().getDouble("to_reach")) continue;
            this.recReach = this.reaches.getEntityArray()[i];
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i;
        for (int i2 = 0; i2 < this.inDataArray.getValue().length; ++i2) {
            if (this.inDataNames.getValue()[i2].equals("runoff")) {
                this.resOutflow.setValue(this.inDataArray.getValue()[i2]);
                continue;
            }
            if (this.inDataNames.getValue()[i2].equals("depth")) {
                this.resDepth.setValue(this.inDataArray.getValue()[i2]);
                continue;
            }
            if (this.inDataNames.getValue()[i2].equals("area")) {
                this.resArea.setValue(this.inDataArray.getValue()[i2]);
                continue;
            }
            if (this.inDataNames.getValue()[i2].equals("volume")) {
                this.resObsVolume.setValue(this.inDataArray.getValue()[i2]);
                continue;
            }
            System.out.println("Error, wrong attribute name in reservoir file!");
        }
        this.runComp[0] = this.compRD1.getValue();
        this.runComp[1] = this.compRD2.getValue();
        this.runComp[2] = this.compRG1.getValue();
        this.runComp[3] = this.compRG2.getValue();
        this.currVolume = this.resCalcVolume.getValue();
        double runArea = this.resArea.getValue();
        double runPET = this.pET.getValue() * runArea;
        this.runComp[0] = this.runComp[0] + this.precip.getValue() * runArea;
        this.calcRelComponents();
        if (this.currVolume < runPET) {
            this.actET.setValue(this.currVolume);
            for (i = 0; i < this.runComp.length; ++i) {
                this.runComp[i] = 0.0;
            }
        } else {
            this.actET.setValue(runPET);
            for (i = 0; i < this.runComp.length; ++i) {
                this.runComp[i] = this.runComp[i] - runPET * this.relComp[i];
            }
        }
        this.calcRelComponents();
        double runOutflow = this.resOutflow.getValue() * 1000.0 * 86400.0;
        if (this.currVolume < runOutflow) {
            for (int i3 = 0; i3 < this.runComp.length; ++i3) {
                this.outComp[i3] = runOutflow * this.relComp[i3];
                this.runComp[i3] = 0.0;
                this.relComp[i3] = 0.0;
            }
        } else {
            for (int i4 = 0; i4 < this.runComp.length; ++i4) {
                this.outComp[i4] = runOutflow * this.relComp[i4];
                this.runComp[i4] = this.runComp[i4] - this.outComp[i4];
            }
        }
        this.calcRelComponents();
        this.recReach.setDouble("inRD1", this.outComp[0] + this.recReach.getDouble("inRD1"));
        this.recReach.setDouble("inRD2", this.outComp[1] + this.recReach.getDouble("inRD2"));
        this.recReach.setDouble("inRG1", this.outComp[2] + this.recReach.getDouble("inRG1"));
        this.recReach.setDouble("inRG2", this.outComp[3] + this.recReach.getDouble("inRG2"));
        this.resCalcVolume.setValue(this.currVolume);
        this.compRD1.setValue(this.runComp[0]);
        this.compRD2.setValue(this.runComp[1]);
        this.compRG1.setValue(this.runComp[2]);
        this.compRG2.setValue(this.runComp[3]);
        System.out.println("" + this.currVolume + "\t" + this.actET.getValue() / runArea + "\t" + this.resOutflow.getValue());
    }

    public void cleanup() {
    }

    private void calcRelComponents() {
        int i;
        this.currVolume = 0.0;
        for (i = 0; i < this.nComp; ++i) {
            this.currVolume += this.runComp[i];
        }
        for (i = 0; i < this.nComp; ++i) {
            this.relComp[i] = this.currVolume > 0.0 ? this.runComp[i] / this.currVolume : 0.0;
        }
    }
}

