/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataReader;
import org.unijena.jams.io.JAMSTableDataArray;
import org.unijena.jams.io.JAMSTableDataConverter;
import org.unijena.jams.io.JAMSTableDataStore;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class ReservoirDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file name")
    public JAMSString dataFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Column of first data value")
    public JAMSInteger startColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Time interval of current temporal context")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of data values for current time step")
    public JAMSDoubleArray dataArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="data field descriptors")
    public JAMSStringArray dataNames = new JAMSStringArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="data set descriptor")
    public JAMSString dataSetName;
    private JAMSTableDataStore store;
    private JAMSTableDataArray da;

    public void init() {
        int headerLineCount = 0;
        String[] dataNames = null;
        String tres = null;
        String start = null;
        String end = null;
        double statx = 0.0;
        double staty = 0.0;
        double statelev = 0.0;
        String fileName = this.dirName.getValue() + "/" + this.dataFileName.getValue();
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String token = strTok.nextToken();
            while (token.compareTo("@dataVal") != 0) {
                String desc;
                int i;
                if (token.compareTo("@dataSetAttribs") == 0) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t");
                        desc = strTok.nextToken();
                        if (desc.compareTo("missingDataVal") == 0) {
                            double missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.compareTo("dataStart") == 0) {
                            start = strTok.nextToken();
                        } else if (desc.compareTo("dataEnd") == 0) {
                            end = strTok.nextToken();
                        } else if (desc.compareTo("tres") == 0) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, "\t");
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (token.compareTo("@statAttribVal") != 0) continue;
                i = 0;
                line = reader.readLine();
                strTok = new StringTokenizer(line, "\t");
                desc = strTok.nextToken();
                if (desc.compareTo("dataColumn") == 0) {
                    int nstat = strTok.countTokens();
                    dataNames = new String[nstat];
                    for (int j = 0; j < nstat; ++j) {
                        dataNames[j] = strTok.nextToken();
                    }
                    ++headerLineCount;
                    ++headerLineCount;
                    ++headerLineCount;
                }
                ++i;
                line = reader.readLine();
                strTok = new StringTokenizer(line, "\t");
                token = strTok.nextToken();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        this.dataNames.setValue(dataNames);
        this.store = new GenericDataReader(this.dirName.getValue() + "/" + this.dataFileName.getValue(), false, headerLineCount + 1);
        JAMSCalendar startTime = this.parseJ2KTime(start);
        JAMSCalendar endTime = this.parseJ2KTime(end);
        if (this.timeInterval != null && (this.timeInterval.getStart().before((Object)startTime) || this.timeInterval.getEnd().after((Object)endTime))) {
            this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.dataFileName.getValue() + " do not match current temporal context!");
        }
        if (this.timeInterval != null) {
            int timeUnit = this.timeInterval.getTimeUnit();
            JAMSCalendar tiStart = this.timeInterval.getStart();
            JAMSCalendar date = new JAMSCalendar(tiStart.get(1), tiStart.get(2), tiStart.get(5), startTime.get(11), startTime.get(12), startTime.get(13));
            while (startTime.before((Object)date) && this.store.hasNext()) {
                this.da = this.store.getNext();
                if (timeUnit == 6) {
                    startTime.add(5, 1);
                    continue;
                }
                if (timeUnit == 11) {
                    startTime.add(11, 1);
                    continue;
                }
                if (timeUnit != 2) continue;
                startTime.add(2, 1);
            }
        }
        this.getModel().getRuntime().println(" reservoir data file initalised ... ", 2);
    }

    public void run() {
        this.dataArray.setValue(JAMSTableDataConverter.toDouble((JAMSTableDataArray)this.store.getNext(), (int)this.startColumn.getValue()));
    }

    private JAMSCalendar parseJ2KTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        JAMSCalendar cal = new JAMSCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }

    public void cleanup() {
        this.store.close();
    }
}

