/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.units.Converter;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NameFactory;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.InternationalString;

public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    public static final DefaultCoordinateSystemAxis LONGITUDE = new DefaultCoordinateSystemAxis(98, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LATITUDE = new DefaultCoordinateSystemAxis(85, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(5, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis DEPTH = new DefaultCoordinateSystemAxis(31, "d", AxisDirection.DOWN, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(58, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(57, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(37, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GRAVITY_RELATED_HEIGHT = new DefaultCoordinateSystemAxis(64, "h", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(52, "r", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(157, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(156, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis X = new DefaultCoordinateSystemAxis("x", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis Y = new DefaultCoordinateSystemAxis("y", AxisDirection.NORTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis Z = new DefaultCoordinateSystemAxis("z", AxisDirection.UP, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X = new DefaultCoordinateSystemAxis(54, "X", AxisDirection.OTHER, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(55, "Y", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(56, "Z", AxisDirection.NORTH, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis EASTING = new DefaultCoordinateSystemAxis(35, "E", AxisDirection.EAST, (Unit)SI.METER);
    public static final DefaultCoordinateSystemAxis WESTING;
    public static final DefaultCoordinateSystemAxis NORTHING;
    public static final DefaultCoordinateSystemAxis SOUTHING;
    public static final DefaultCoordinateSystemAxis TIME;
    public static final DefaultCoordinateSystemAxis COLUMN;
    public static final DefaultCoordinateSystemAxis ROW;
    public static final DefaultCoordinateSystemAxis DISPLAY_X;
    public static final DefaultCoordinateSystemAxis DISPLAY_Y;
    private static final Map ALIASES;
    private final String abbreviation;
    private final AxisDirection direction;
    private final Unit unit;
    private final double minimum;
    private final double maximum;
    private final RangeMeaning rangeMeaning;
    private transient DefaultCoordinateSystemAxis opposite;

    public DefaultCoordinateSystemAxis(CoordinateSystemAxis axis) {
        super(axis);
        this.abbreviation = axis.getAbbreviation();
        this.direction = axis.getDirection();
        this.unit = axis.getUnit();
        this.minimum = axis.getMinimumValue();
        this.maximum = axis.getMaximumValue();
        this.rangeMeaning = axis.getRangeMeaning();
    }

    public DefaultCoordinateSystemAxis(Map properties, String abbreviation, AxisDirection direction, Unit unit, double minimum, double maximum, RangeMeaning rangeMeaning) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        this.minimum = minimum;
        this.maximum = maximum;
        this.rangeMeaning = rangeMeaning;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", abbreviation);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        DefaultCoordinateSystemAxis.ensureNonNull("rangeMeaning", rangeMeaning);
        if (!(minimum < maximum)) {
            throw new IllegalArgumentException(Errors.format(13, new Double(minimum), new Double(maximum)));
        }
    }

    public DefaultCoordinateSystemAxis(Map properties, String abbreviation, AxisDirection direction, Unit unit) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", abbreviation);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        if (unit.isCompatible(NonSI.DEGREE_ANGLE)) {
            Converter fromDegrees = NonSI.DEGREE_ANGLE.getConverterTo(unit);
            AxisDirection dir = direction.absolute();
            if (dir.equals(AxisDirection.NORTH)) {
                double range = Math.abs(fromDegrees.convert(90.0));
                this.minimum = -range;
                this.maximum = range;
                this.rangeMeaning = RangeMeaning.EXACT;
                return;
            }
            if (dir.equals(AxisDirection.EAST)) {
                double range = Math.abs(fromDegrees.convert(180.0));
                this.minimum = -range;
                this.maximum = range;
                this.rangeMeaning = RangeMeaning.WRAPAROUND;
                return;
            }
        }
        this.minimum = Double.NEGATIVE_INFINITY;
        this.maximum = Double.POSITIVE_INFINITY;
        this.rangeMeaning = RangeMeaning.EXACT;
    }

    public DefaultCoordinateSystemAxis(String abbreviation, AxisDirection direction, Unit unit) {
        this(Collections.singletonMap("name", abbreviation), abbreviation, direction, unit);
    }

    public DefaultCoordinateSystemAxis(InternationalString name, String abbreviation, AxisDirection direction, Unit unit) {
        this(DefaultCoordinateSystemAxis.toMap(name), abbreviation, direction, unit);
    }

    private static Map toMap(InternationalString name) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (name != null) {
            properties.put("name", name.toString(Locale.US));
            properties.put("alias", NameFactory.create(new InternationalString[]{name}));
        }
        return properties;
    }

    private DefaultCoordinateSystemAxis(int name, String abbreviation, AxisDirection direction, Unit unit) {
        this(Vocabulary.formatInternational(name), abbreviation, direction, unit);
    }

    public static AxisDirection getDirection(String direction) throws NoSuchElementException {
        String search = direction.trim();
        AxisDirection[] values = AxisDirection.values();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            AxisDirection candidate = values[i];
            String name = candidate.name();
            if (!search.equalsIgnoreCase(name)) continue;
            return candidate;
        }
        throw new NoSuchElementException(Errors.format(152, direction));
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public AxisDirection getDirection() {
        return this.direction;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public double getMinimumValue() {
        return this.minimum;
    }

    public double getMaximumValue() {
        return this.maximum;
    }

    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    final CoordinateSystemAxis getOpposite() {
        return this.opposite;
    }

    final DefaultCoordinateSystemAxis usingUnit(Unit unit) throws IllegalArgumentException {
        if (this.unit.equals((Object)unit)) {
            return this;
        }
        if (this.unit.isCompatible(unit)) {
            return new DefaultCoordinateSystemAxis(DefaultCoordinateSystemAxis.getProperties(this, null), this.abbreviation, this.direction, unit, this.minimum, this.maximum, this.rangeMeaning);
        }
        throw new IllegalArgumentException(Errors.format(54, unit));
    }

    public boolean nameMatches(String name) {
        if (super.nameMatches(name)) {
            return true;
        }
        Object type = ALIASES.get(name.toLowerCase().trim());
        return type != null && type == ALIASES.get(this.getName().getCode().toLowerCase().trim());
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultCoordinateSystemAxis that = (DefaultCoordinateSystemAxis)object;
            if (compareMetadata ? !Utilities.equals(this.abbreviation, that.abbreviation) || !Utilities.equals(this.rangeMeaning, that.rangeMeaning) || Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(that.minimum) || Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(that.maximum) : !this.nameMatches(that.getName().getCode()) && !DefaultCoordinateSystemAxis.nameMatches(that, this.getName().getCode())) {
                return false;
            }
            return Utilities.equals(this.direction, that.direction) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        int code = 1684127127;
        code = code * 37 + this.abbreviation.hashCode();
        code = code * 37 + this.direction.hashCode();
        code = code * 37 + this.unit.hashCode();
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append(this.direction);
        return "AXIS";
    }

    static {
        DefaultCoordinateSystemAxis.EASTING.opposite = WESTING = new DefaultCoordinateSystemAxis(188, "W", AxisDirection.WEST, (Unit)SI.METER);
        DefaultCoordinateSystemAxis.WESTING.opposite = EASTING;
        NORTHING = new DefaultCoordinateSystemAxis(113, "N", AxisDirection.NORTH, (Unit)SI.METER);
        DefaultCoordinateSystemAxis.NORTHING.opposite = SOUTHING = new DefaultCoordinateSystemAxis(155, "S", AxisDirection.SOUTH, (Unit)SI.METER);
        DefaultCoordinateSystemAxis.SOUTHING.opposite = NORTHING;
        TIME = new DefaultCoordinateSystemAxis(166, "t", AxisDirection.FUTURE, NonSI.DAY);
        COLUMN = new DefaultCoordinateSystemAxis(18, "i", AxisDirection.COLUMN_POSITIVE, Unit.ONE);
        ROW = new DefaultCoordinateSystemAxis(143, "j", AxisDirection.ROW_POSITIVE, Unit.ONE);
        DISPLAY_X = new DefaultCoordinateSystemAxis("x", AxisDirection.DISPLAY_RIGHT, Unit.ONE);
        DISPLAY_Y = new DefaultCoordinateSystemAxis("y", AxisDirection.DISPLAY_DOWN, Unit.ONE);
        ALIASES = new HashMap(8);
        ALIASES.put("lat", GEODETIC_LATITUDE);
        ALIASES.put("latitude", GEODETIC_LATITUDE);
        ALIASES.put("geodetic latitude", GEODETIC_LATITUDE);
        ALIASES.put("lon", GEODETIC_LONGITUDE);
        ALIASES.put("longitude", GEODETIC_LONGITUDE);
        ALIASES.put("geodetic longitude", GEODETIC_LONGITUDE);
    }
}

