/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.collection.ResourceCollection;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public abstract class FeatureState {
    protected Envelope bounds = null;
    protected ResourceCollection data;

    protected FeatureState(ResourceCollection collection) {
        this.data = collection;
    }

    public abstract void addListener(CollectionListener var1);

    public abstract void removeListener(CollectionListener var1);

    protected abstract void fireChange(Feature[] var1, int var2);

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            Iterator i = this.data.iterator();
            try {
                while (i.hasNext()) {
                    Envelope geomBounds = ((Feature)i.next()).getBounds();
                    if (geomBounds.isNull()) continue;
                    this.bounds.expandToInclude(geomBounds);
                }
            }
            finally {
                this.data.close(i);
            }
        }
        return this.bounds;
    }

    public abstract FeatureType getFeatureType();

    public abstract FeatureType getChildFeatureType();

    public abstract String getId();

    public FeatureCollection getParent() {
        return null;
    }

    public void setParent(FeatureCollection parent) {
        throw new UnsupportedOperationException();
    }

    public Object[] getAttributes(Object[] attributes) {
        List list = (List)this.getAttribute(0);
        return list.toArray(attributes);
    }

    public Object getAttribute(String xPath) {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1) {
            if (xPath.endsWith("]")) {
                return this.getAttribute(0);
            }
            return this.getAttribute(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(int index) {
        if (index == 0) {
            Iterator i = this.data.iterator();
            Feature list = new ArrayList();
            try {
                Feature feature;
                while (i.hasNext()) {
                    feature = (Feature)i.next();
                    list.add(feature);
                }
                feature = list;
                return feature;
            }
            catch (NoSuchElementException e) {
                List list2 = Collections.EMPTY_LIST;
                return list2;
            }
            finally {
                this.data.close(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        if (position == 0 && val instanceof Collection) {
            Collection newStuff = (Collection)val;
            if (!FeatureState.isFeatures(newStuff)) {
                throw new IllegalAttributeException("Content must be features");
            }
            this.data.clear();
            Iterator i = newStuff.iterator();
            try {
                while (i.hasNext()) {
                    Feature feature = (Feature)i.next();
                    if (this.data instanceof FeatureCollection) {
                        feature.setParent((FeatureCollection)this.data);
                    }
                    this.data.add((Object)feature);
                }
            }
            finally {
                this.data.close(i);
            }
        }
    }

    public int getNumberOfAttributes() {
        return this.getFeatureType().getAttributeCount();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1 && !xPath.endsWith("]")) {
            this.setAttribute(0, attribute);
        }
    }

    public Geometry getDefaultGeometry() {
        return null;
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        throw new IllegalAttributeException("DefaultGeometry not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set fids(Collection stuff) {
        if (stuff instanceof DefaultFeatureCollection) {
            DefaultFeatureCollection features = (DefaultFeatureCollection)((Object)stuff);
            return features.fids();
        }
        Iterator iterator = stuff.iterator();
        HashSet<String> fids = new HashSet<String>();
        try {
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                fids.add(feature.getID());
            }
        }
        finally {
            if (stuff instanceof ResourceCollection) {
                ((ResourceCollection)stuff).close(iterator);
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFeatures(Collection stuff) {
        if (stuff instanceof FeatureCollection) {
            return true;
        }
        Iterator i = stuff.iterator();
        try {
            while (i.hasNext()) {
                if (i.next() instanceof Feature) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (stuff instanceof ResourceCollection) {
                ((ResourceCollection)stuff).close(i);
            }
        }
        return true;
    }
}

