/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.renderer.shape.GeometryHandlerUtilities;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.renderer.shape.SimpleGeometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class PolygonHandler
implements ShapeHandler {
    private ShapeType type;
    private Envelope bbox;
    double spanx;
    double spany;
    private MathTransform mt;

    public PolygonHandler(ShapeType type, Envelope env, MathTransform mt, boolean hasOpacity) throws TransformException {
        this.type = type;
        this.bbox = env;
        this.mt = mt;
        if (mt != null) {
            Point2D span = GeometryHandlerUtilities.calculateSpan(mt, 0, 0);
            this.spanx = span.getX();
            this.spany = span.getY();
        }
    }

    public ShapeType getShapeType() {
        return this.type;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return null;
        }
        Envelope geomBBox = GeometryHandlerUtilities.readBounds(buffer);
        if (!this.bbox.intersects(geomBBox)) {
            return null;
        }
        boolean bboxdecimate = geomBBox.getWidth() <= this.spanx && geomBBox.getHeight() <= this.spany;
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        double[][] coords = new double[numParts][];
        double[][] transformed = new double[numParts][];
        int start = 0;
        int length = 0;
        if (bboxdecimate) {
            coords = new double[][]{new double[4]};
            transformed = new double[][]{new double[8]};
            coords[0][0] = buffer.getDouble();
            coords[0][1] = buffer.getDouble();
            try {
                this.mt.transform(coords[0], 0, transformed[0], 0, 1);
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                transformed[0] = coords[0];
            }
            transformed[0][2] = transformed[0][0];
            transformed[0][3] = transformed[0][1] + 0.1;
            transformed[0][4] = transformed[0][0] + 0.1;
            transformed[0][5] = transformed[0][1] + 0.1;
            transformed[0][6] = transformed[0][0];
            transformed[0][7] = transformed[0][1];
        } else {
            Envelope partEnvelope = new Envelope();
            int partsInBBox = 0;
            for (int part = 0; part < numParts; ++part) {
                start = partOffsets[part];
                partEnvelope.init();
                int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - start;
                int totalDoubles = length * 2;
                coords[part] = new double[totalDoubles];
                int readDoubles = 0;
                int currentDoubles = 0;
                while (currentDoubles < totalDoubles) {
                    try {
                        coords[part][readDoubles] = buffer.getDouble();
                        ++currentDoubles;
                        coords[part][++readDoubles] = buffer.getDouble();
                        ++readDoubles;
                        ++currentDoubles;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (this.collapsePoints(coords, part, totalDoubles, readDoubles, currentDoubles)) {
                        readDoubles -= 2;
                        continue;
                    }
                    partEnvelope.expandToInclude(coords[part][readDoubles - 2], coords[part][readDoubles - 1]);
                }
                if (!partEnvelope.intersects(this.bbox)) continue;
                transformed[partsInBBox] = readDoubles < 8 ? new double[8] : new double[readDoubles];
                if (!this.mt.isIdentity()) {
                    try {
                        GeometryHandlerUtilities.transform(type, this.mt, coords[part], transformed[partsInBBox]);
                    }
                    catch (Exception e) {
                        ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                        transformed[partsInBBox] = coords[part];
                    }
                } else {
                    System.arraycopy(coords[part], 0, transformed[partsInBBox], 0, readDoubles / 2);
                }
                if (readDoubles < 8) {
                    for (int i = readDoubles; i < transformed[partsInBBox].length; ++i) {
                        transformed[partsInBBox][i] = transformed[partsInBBox][i - 2];
                    }
                }
                ++partsInBBox;
            }
            if (partsInBBox == 0) {
                return null;
            }
            if (partsInBBox != numParts) {
                double[][] tmp = new double[partsInBBox][];
                System.arraycopy(transformed, 0, tmp, 0, partsInBBox);
                transformed = tmp;
            }
        }
        return new SimpleGeometry(type, transformed, geomBBox);
    }

    private boolean collapsePoints(double[][] coords, int part, int totalDoubles, int readDoubles, int currentDoubles) {
        return currentDoubles > 3 && currentDoubles < totalDoubles - 1 && Math.abs(coords[part][readDoubles - 4] - coords[part][readDoubles - 2]) <= this.spanx && Math.abs(coords[part][readDoubles - 3] - coords[part][readDoubles - 1]) <= this.spany;
    }

    public void write(ByteBuffer buffer, Object geometry) {
        throw new UnsupportedOperationException("This handler is only for reading");
    }

    public int getLength(Object geometry) {
        return 0;
    }
}

