/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.Renderer;
import org.geotools.renderer.Renderer2D;
import org.geotools.renderer.lite.Decimator;
import org.geotools.renderer.lite.ImageLoader;
import org.geotools.renderer.lite.IndexedFeatureResults;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheDefault;
import org.geotools.renderer.lite.ListenerList;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class LiteRenderer2
implements Renderer,
Renderer2D {
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.rendering");
    int error = 0;
    public static final DefaultRenderListener DEFAULT_LISTENER = new DefaultRenderListener();
    private FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
    private static final CoordinateOperationFactory operationFactory;
    private static final MathTransformFactory mathTransformFactory;
    private MapContext context;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private Envelope mapExtent = null;
    private Graphics2D outputGraphics;
    private Rectangle screenSize;
    private boolean optimizedDataLoadingEnabled;
    private boolean renderingStopRequested;
    private double scaleDenominator;
    private double generalizationDistance = 1.0;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    LabelCache labelCache = new LabelCacheDefault();
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private HashMap transformMap = new HashMap();
    private boolean canTransform = true;
    private boolean memoryPreloadingEnabled;
    private IndexedFeatureResults indexedFeatureResults;
    private ListenerList renderListeners = new ListenerList();
    private RenderingHints hints;
    HashMap decimators = new HashMap();

    public LiteRenderer2() {
        this.addRenderListener(DEFAULT_LISTENER);
    }

    public LiteRenderer2(MapContext context) {
        this();
        this.context = context;
    }

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public static long getImageLoadingTimeout() {
        return ImageLoader.getTimeout();
    }

    public static void setImageLoadingTimeout(long newTimeout) {
        ImageLoader.setTimeout(newTimeout);
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    public void setOutput(Graphics g, Rectangle bounds) {
        this.outputGraphics = (Graphics2D)g;
        this.screenSize = bounds;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Feature feature) {
        Object[] objects = this.renderListeners.getListeners();
        for (int i = 0; i < objects.length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.featureRenderer(feature);
        }
    }

    private void fireErrorEvent(Exception e) {
        Object[] objects = this.renderListeners.getListeners();
        for (int i = 0; i < objects.length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.errorOccurred(e);
        }
    }

    protected void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform transform) {
        AffineTransform pixelToWorld = null;
        try {
            pixelToWorld = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        pixelToWorld.transform(new Point2D.Double(paintArea.getMinX(), paintArea.getMinY()), p1);
        pixelToWorld.transform(new Point2D.Double(paintArea.getMaxX(), paintArea.getMaxY()), p2);
        double x1 = ((Point2D)p1).getX();
        double y1 = ((Point2D)p1).getY();
        double x2 = ((Point2D)p2).getX();
        double y2 = ((Point2D)p2).getY();
        Envelope envelope = new Envelope(Math.min(x1, x2), Math.max(x1, x2), Math.min(y1, y2), Math.max(y1, y2));
        this.paint(graphics, paintArea, envelope);
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope envelope) {
        AffineTransform transform = this.worldToScreenTransform(envelope, paintArea);
        this.error = 0;
        if (this.hints != null) {
            graphics.setRenderingHints(this.hints);
        }
        if (graphics == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.renderingStopRequested = false;
        AffineTransform at = transform;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Affine Transform is " + at);
        }
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(at);
            at = atg;
        }
        try {
            this.setScaleDenominator(LiteRenderer2.calculateScale(envelope, this.context.getCoordinateReferenceSystem(), paintArea.width, paintArea.height, 90.0));
        }
        catch (Exception e) {
            this.setScaleDenominator(1.0 / at.getScaleX());
        }
        MapLayer[] layers = this.context.getLayers();
        CoordinateReferenceSystem destinationCrs = this.context.getCoordinateReferenceSystem();
        this.labelCache.start();
        for (int i = 0; i < layers.length; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            this.labelCache.startLayer();
            try {
                FeatureResults results = this.queryLayer(currLayer, envelope, destinationCrs);
                this.processStylers(graphics, results, currLayer.getStyle().getFeatureTypeStyles(), at, this.context.getCoordinateReferenceSystem(), currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem());
            }
            catch (Exception exception) {
                this.fireErrorEvent(new Exception("Exception rendering layer " + currLayer, exception));
            }
            this.labelCache.endLayer(graphics, this.screenSize);
        }
        this.labelCache.end(graphics, paintArea);
        LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        if (this.error > 0) {
            LOGGER.warning("Number of Errors during paint(Graphics2D, AffineTransform) = " + this.error);
        }
    }

    public static double calculateScale(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem, int imageWidth, int imageHeight, double DPI) throws Exception {
        double diagonalGroundDistance = JTS.orthodromicDistance((Coordinate)new Coordinate(envelope.getMinX(), envelope.getMinY()), (Coordinate)new Coordinate(envelope.getMaxX(), envelope.getMaxY()), (CoordinateReferenceSystem)coordinateReferenceSystem);
        double diagonalPixelDistancePixels = Math.sqrt(imageWidth * imageWidth + imageHeight * imageHeight);
        double diagonalPixelDistanceMeters = diagonalPixelDistancePixels / DPI * 2.54 / 100.0;
        return diagonalGroundDistance / diagonalPixelDistanceMeters;
    }

    FeatureResults queryLayer(MapLayer currLayer, Envelope envelope, CoordinateReferenceSystem destinationCrs) throws IllegalFilterException, IOException, IllegalAttributeException {
        Query definitionQuery;
        Object results = null;
        FeatureSource featureSource = currLayer.getFeatureSource();
        FeatureType schema = featureSource.getSchema();
        Query query = Query.ALL;
        MathTransform transform = null;
        if (this.optimizedDataLoadingEnabled) {
            String[] attributes = this.findStyleAttributes(currLayer, schema);
            try {
                CoordinateReferenceSystem sourceCrs = currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem();
                if (sourceCrs != null && !sourceCrs.equals(destinationCrs)) {
                    transform = operationFactory.createOperation(destinationCrs, sourceCrs).getMathTransform();
                    if (transform != null && !transform.isIdentity()) {
                        envelope = org.geotools.geometry.JTS.transform((Envelope)envelope, (MathTransform)transform, (int)10);
                    } else {
                        transform = null;
                    }
                }
                Filter filter = null;
                if (!this.memoryPreloadingEnabled) {
                    BBoxExpression rightBBox = this.filterFactory.createBBoxExpression(envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                } else {
                    filter = Filter.NONE;
                }
                DefaultQuery q = new DefaultQuery(schema.getTypeName());
                q.setFilter(filter);
                q.setPropertyNames(attributes);
                query = q;
            }
            catch (Exception e) {
                this.fireErrorEvent(new Exception("Error transforming bbox", e));
                this.canTransform = false;
                DefaultQuery q = new DefaultQuery(schema.getTypeName());
                q.setPropertyNames(attributes);
                if (envelope.intersects(featureSource.getBounds())) {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)");
                    Filter filter = null;
                    BBoxExpression rightBBox = this.filterFactory.createBBoxExpression(envelope);
                    filter = this.createBBoxFilters(schema, attributes, rightBBox);
                    q.setFilter(filter);
                } else {
                    LOGGER.fine("Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)");
                    q.setFilter(Filter.NONE);
                }
                query = q;
            }
        }
        if ((definitionQuery = currLayer.getQuery()) != Query.ALL) {
            query = query == Query.ALL ? definitionQuery : DataUtilities.mixQueries((Query)definitionQuery, (Query)query, (String)"liteRenderer");
        }
        if (!(query instanceof DefaultQuery)) {
            query = new DefaultQuery(query);
        }
        ((DefaultQuery)query).setCoordinateSystem(currLayer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem());
        if (this.memoryPreloadingEnabled) {
            if (this.indexedFeatureResults == null) {
                this.indexedFeatureResults = new IndexedFeatureResults((FeatureResults)featureSource.getFeatures(query));
            }
            this.indexedFeatureResults.setQueryBounds(envelope);
            results = this.indexedFeatureResults;
        } else {
            results = featureSource.getFeatures(query);
        }
        return results;
    }

    private String[] findStyleAttributes(MapLayer layer, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(layer.getStyle());
        String[] ftsAttributes = sae.getAttributeNames();
        LinkedList<String> atts = new LinkedList<String>(Arrays.asList(ftsAttributes));
        AttributeType[] attTypes = schema.getAttributeTypes();
        for (int i = 0; i < attTypes.length; ++i) {
            String attName = attTypes[i].getName();
            if (!(attTypes[i] instanceof GeometryAttributeType) && !attTypes[i].getName().equalsIgnoreCase("grid") || atts.contains(attName)) continue;
            atts.add(attName);
            LOGGER.fine("added attribute " + attName);
        }
        ftsAttributes = new String[atts.size()];
        atts.toArray(ftsAttributes);
        return ftsAttributes;
    }

    private Filter createBBoxFilters(FeatureType schema, String[] attributes, BBoxExpression bbox) throws IllegalFilterException {
        Object filter = null;
        for (int j = 0; j < attributes.length; ++j) {
            AttributeType attType = schema.getAttributeType(attributes[j]);
            if (attType == null) {
                throw new IllegalFilterException("Could not find '" + attributes[j] + "' in the FeatureType (" + schema.getTypeName() + ")");
            }
            if (!(attType instanceof GeometryAttributeType)) continue;
            GeometryFilter gfilter = this.filterFactory.createGeometryFilter((short)4);
            AttributeExpression left = this.filterFactory.createAttributeExpression(schema, attType.getName());
            gfilter.addLeftGeometry((Expression)left);
            gfilter.addRightGeometry((Expression)bbox);
            filter = filter == null ? gfilter : filter.or((Filter)gfilter);
        }
        return filter;
    }

    public void render(FeatureCollection features, Envelope map, Style s) {
        if (this.outputGraphics == null) {
            LOGGER.info("renderer passed null graphics");
            return;
        }
        this.renderingStopRequested = false;
        long startTime = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
        }
        this.mapExtent = map;
        AffineTransform at = this.worldToScreenTransform(this.mapExtent, this.screenSize);
        this.scaleDenominator = 1.0 / this.outputGraphics.getTransform().getScaleX();
        FeatureTypeStyle[] featureStylers = s.getFeatureTypeStyles();
        try {
            this.processStylers(this.outputGraphics, DataUtilities.results((FeatureCollection)features), featureStylers, at, null, null);
        }
        catch (IOException ioe) {
            this.fireErrorEvent(new Exception("I/O error while rendering the layer", ioe));
        }
        catch (IllegalAttributeException iae) {
            this.fireErrorEvent(new Exception("Illegal attribute exception while rendering the layer", iae));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long endTime = System.currentTimeMillis();
            double elapsed = (double)(endTime - startTime) / 1000.0;
        }
    }

    public AffineTransform worldToScreenTransform(Envelope mapExtent, Rectangle screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        AffineTransform originTranslation = AffineTransform.getTranslateInstance(screenSize.x, screenSize.y);
        originTranslation.concatenate(at);
        return originTranslation != null ? originTranslation : at;
    }

    public Coordinate pixelToWorld(int x, int y, Envelope map) {
        if (this.outputGraphics == null) {
            LOGGER.info("no graphics yet deffined");
            return null;
        }
        AffineTransform at = this.worldToScreenTransform(map, this.screenSize);
        if (this.concatTransforms) {
            this.outputGraphics.getTransform().concatenate(at);
        } else {
            this.outputGraphics.setTransform(at);
        }
        try {
            Point2D result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
            Coordinate c = new Coordinate(result.getX(), result.getY());
            return c;
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            return null;
        }
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    private void processStylers(Graphics2D graphics, FeatureResults features, FeatureTypeStyle[] featureStylers, AffineTransform at, CoordinateReferenceSystem destinationCrs, CoordinateReferenceSystem sourceCrs) throws IOException, IllegalAttributeException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("processing " + featureStylers.length + " stylers for " + features.getSchema().getTypeName());
        }
        this.transformMap = new HashMap();
        for (int i = 0; i < featureStylers.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("processing style " + i);
            }
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = features.getSchema().getTypeName();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("... done: " + typeName);
            }
            if (typeName == null || !features.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (int j = 0; j < rules.length; ++j) {
                Rule r;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("processing rule " + j);
                }
                if (!this.isWithInScale(r = rules[j])) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            if (ruleList.size() == 0 && elseRuleList.size() == 0) {
                return;
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            FeatureReader reader = features.reader();
            CoordinateReferenceSystem rCS = reader.getFeatureType().getDefaultGeometry().getCoordinateSystem();
            if (!(rCS == sourceCrs || sourceCrs == null || rCS != null && rCS.equals(sourceCrs))) {
                try {
                    reader = new ForceCoordinateSystemFeatureReader(reader, sourceCrs);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            while (true) {
                try {
                    while (!this.renderingStopRequested && reader.hasNext()) {
                        Rule r;
                        boolean doElse = true;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.fine("trying to read Feature ...");
                        }
                        Feature feature = reader.next();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("... done: " + feature.toString());
                        }
                        Iterator it = ruleList.iterator();
                        while (it.hasNext()) {
                            Filter filter;
                            r = (Rule)it.next();
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("applying rule: " + r.toString());
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("this rule applies ...");
                            }
                            if ((filter = r.getFilter()) != null && !filter.contains(feature)) continue;
                            doElse = false;
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("processing Symobolizer ...");
                            }
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, at, destinationCrs);
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("... done!");
                        }
                        if (doElse) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("rules with an else filter");
                            }
                            it = elseRuleList.iterator();
                            while (it.hasNext()) {
                                r = (Rule)it.next();
                                Symbolizer[] symbolizers = r.getSymbolizers();
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("processing Symobolizer ...");
                                }
                                this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, at, destinationCrs);
                                if (!LOGGER.isLoggable(Level.FINER)) continue;
                                LOGGER.finer("... done!");
                            }
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("feature rendered event ...");
                    }
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    continue;
                }
                break;
            }
            reader.close();
        }
    }

    private void processSymbolizers(Graphics2D graphics, Feature feature, Symbolizer[] symbolizers, Range scaleRange, AffineTransform at, CoordinateReferenceSystem destinationCrs) throws TransformException, FactoryException {
        for (int m = 0; m < symbolizers.length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            if (symbolizers[m] instanceof RasterSymbolizer) {
                AffineTransform tempTransform = graphics.getTransform();
                graphics.setTransform(at);
                this.renderRaster(graphics, feature, (RasterSymbolizer)symbolizers[m], destinationCrs);
                graphics.setTransform(tempTransform);
                continue;
            }
            Geometry g = this.findGeometry(feature, symbolizers[m]);
            CoordinateReferenceSystem crs = this.findGeometryCS(feature, symbolizers[m]);
            MathTransform2D transform = null;
            if (this.canTransform) {
                try {
                    transform = this.getMathTransform(crs, destinationCrs);
                    transform = transform != null ? (MathTransform2D)mathTransformFactory.createConcatenatedTransform((MathTransform)transform, mathTransformFactory.createAffineTransform((Matrix)new GeneralMatrix(at))) : (MathTransform2D)mathTransformFactory.createAffineTransform((Matrix)new GeneralMatrix(at));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            LiteShape2 shape = this.getTransformedShape(g, transform);
            if (symbolizers[m] instanceof TextSymbolizer) {
                this.labelCache.put((TextSymbolizer)symbolizers[m], feature, shape, scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.painter.paint(graphics, shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private LiteShape2 getTransformedShape(Geometry g, MathTransform2D transform) throws TransformException, FactoryException {
        LiteShape2 shape = new LiteShape2(g, (MathTransform)transform, this.getDecimator(transform), false);
        return shape;
    }

    private Decimator getDecimator(MathTransform2D mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
        Decimator decimator = (Decimator)this.decimators.get(mathTransform);
        if (decimator == null) {
            decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse()) : new Decimator(null);
            this.decimators.put(mathTransform, decimator);
        }
        return decimator;
    }

    private MathTransform2D getMathTransform(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem destinationCrs) throws OperationNotFoundException, FactoryException {
        MathTransform2D transform = (MathTransform2D)this.transformMap.get(sourceCrs);
        if (transform != null) {
            return transform;
        }
        if (sourceCrs == null || destinationCrs == null) {
            return null;
        }
        transform = (MathTransform2D)operationFactory.createOperation(sourceCrs, destinationCrs).getMathTransform();
        this.transformMap.put(sourceCrs, transform);
        return transform;
    }

    private void renderRaster(Graphics2D graphics, Feature feature, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS) {
        LOGGER.fine("rendering Raster for feature " + feature.toString() + " - " + feature.getAttribute("grid"));
        float alpha = this.getOpacity(symbolizer);
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        try {
            GridCoverageRenderer gcr = new GridCoverageRenderer(destinationCRS, this.mapExtent, this.screenSize);
            gcr.paint(graphics, (GridCoverage2D)feature.getAttribute("grid"), symbolizer);
            LOGGER.fine("Raster rendered");
        }
        catch (TransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private float getOpacity(RasterSymbolizer sym) {
        float alpha = 1.0f;
        Expression exp = sym.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private Geometry findGeometry(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if (s instanceof PointSymbolizer) {
            geom = this.getCentroid(geom);
        }
        return geom;
    }

    public Geometry getCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            for (int t = 0; t < gc.getNumGeometries(); ++t) {
                pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        return g.getCentroid();
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        if (geomName != null) {
            return ((GeometryAttributeType)f.getFeatureType().getAttributeType(geomName)).getCoordinateSystem();
        }
        return f.getFeatureType().getDefaultGeometry().getCoordinateSystem();
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isOptimizedDataLoadingEnabled() {
        return this.optimizedDataLoadingEnabled;
    }

    public void setOptimizedDataLoadingEnabled(boolean b) {
        this.optimizedDataLoadingEnabled = b;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    public void setMemoryPreloadingEnabled(boolean enabled) {
        this.memoryPreloadingEnabled = enabled;
        if (!enabled) {
            this.indexedFeatureResults = null;
        }
    }

    public void setRenderingHints(RenderingHints hints) {
        this.hints = hints;
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.hints == null) {
            this.hints = new RenderingHints(key, value);
        } else {
            this.hints.put(key, value);
        }
    }

    static {
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        operationFactory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
        hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        mathTransformFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
    }

    private static class DefaultRenderListener
    implements RenderListener {
        private DefaultRenderListener() {
        }

        public void featureRenderer(Feature feature) {
        }

        public void errorOccurred(Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

