/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotools.data.collection.ResourceCollection;
import org.geotools.data.collection.ResourceList;
import org.geotools.feature.collection.AbstractResourceList;

public class SubResourceList
extends AbstractResourceList
implements ResourceCollection,
List {
    ResourceList collection;
    int fromIndex;
    int toIndex;

    public SubResourceList(ResourceList collection, int from, int to) {
        this.collection = collection;
        this.fromIndex = from;
        this.toIndex = to;
    }

    public Object get(int index) {
        return this.collection.get(index - this.fromIndex);
    }

    public int size() {
        return this.toIndex - this.fromIndex;
    }

    protected Iterator openIterator() {
        return this.openIterator(0);
    }

    public ListIterator openIterator(int index) {
        return new SubResourceListIterator(index);
    }

    protected void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        if (close instanceof SubResourceListIterator) {
            SubResourceListIterator it = (SubResourceListIterator)close;
            this.collection.close((Iterator)it.delegate);
        }
        this.open.remove(close);
    }

    public void clear() {
        this.collection.removeRange(this.fromIndex, this.toIndex);
    }

    private class SubResourceListIterator
    implements ListIterator {
        ListIterator delegate;

        SubResourceListIterator(int index) {
            this.delegate = SubResourceList.this.collection.listIterator(index + SubResourceList.this.fromIndex);
        }

        public boolean hasNext() {
            return this.delegate.nextIndex() < SubResourceList.this.toIndex;
        }

        public Object next() {
            if (this.delegate.nextIndex() >= SubResourceList.this.toIndex) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        public void remove() {
            this.delegate.remove();
            --SubResourceList.this.toIndex;
        }

        public boolean hasPrevious() {
            return this.delegate.previousIndex() > SubResourceList.this.fromIndex;
        }

        public Object previous() {
            if (this.delegate.nextIndex() < SubResourceList.this.fromIndex) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        public int nextIndex() {
            return this.delegate.nextIndex() + SubResourceList.this.fromIndex;
        }

        public int previousIndex() {
            return this.delegate.previousIndex() + SubResourceList.this.fromIndex;
        }

        public void set(Object o) {
            this.delegate.set(o);
        }

        public void add(Object o) {
            this.delegate.add(o);
            ++SubResourceList.this.toIndex;
        }
    }
}

