/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.feature.Feature;

public class MultiColumnFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;
    private static final String UTF8 = "UTF-8";

    public MultiColumnFIDMapper(String tableSchemaName, String tableName, String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        super(tableSchemaName, tableName);
        if (colNames == null || colTypes == null || autoIncrement == null) {
            throw new IllegalArgumentException("Column description arrays must be not null");
        }
        if (colNames.length == 0) {
            throw new IllegalArgumentException("Column description arrays must be not empty");
        }
        if (colNames.length != colTypes.length || colNames.length != autoIncrement.length) {
            throw new IllegalArgumentException("Column description arrays must have the same size");
        }
        this.colNames = colNames;
        this.colTypes = colTypes;
        this.colSizes = colSizes;
        this.colDecimalDigits = colDecimalDigits;
        this.autoIncrement = autoIncrement;
        this.returnFIDColumnsAsAttributes = true;
    }

    public MultiColumnFIDMapper(String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        this(null, null, colNames, colTypes, colSizes, colDecimalDigits, autoIncrement);
    }

    public String getID(Object[] attributes) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                sb.append(URLEncoder.encode(attributes[i].toString(), UTF8));
                if (i >= attributes.length - 1) continue;
                sb.append("&");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        Object[] attributes = FID.split("&");
        if (attributes.length != this.colNames.length) {
            throw new DataSourceException("The FID is not compatible with MultiColumnFIDMapper, was expecting " + this.colNames.length + " URL-encoded columns and got " + attributes.length + " columns");
        }
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = URLDecoder.decode((String)attributes[i], UTF8);
        }
        return attributes;
    }

    public String createID(Connection conn, Feature feature, Statement statement) throws IOException {
        Object[] attValues = new String[this.colNames.length];
        for (int i = 0; i < this.colNames.length; ++i) {
            attValues[i] = feature.getAttribute(this.colNames[i]).toString();
        }
        return this.getID(attValues);
    }
}

