/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SpatialAggregator", author="Sven Kralisch", description="Aggregates spatial parameters values of all entities in an entity collection.These can be optionally weighted by the entities area.")
public class SpatialAggregator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Target entity keeping the aggregated data")
    public JAMSEntity targetEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name of regionalised data")
    public JAMSString aNameData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name of entity area")
    public JAMSString aNameArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Aggregation type")
    public JAMSInteger aggregationType;

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity[] entities = this.hrus.getEntityArray();
        double dataSum = 0.0;
        double areaSum = 0.0;
        double area = 0.0;
        if (this.aggregationType.getValue() == 1) {
            for (int i = 0; i < entities.length; ++i) {
                area = entities[i].getDouble(this.aNameArea.getValue());
                areaSum += area;
                dataSum += entities[i].getDouble(this.aNameData.getValue()) * area;
            }
            dataSum /= areaSum;
        } else if (this.aggregationType.getValue() == 0) {
            for (int i = 0; i < entities.length; ++i) {
                dataSum += entities[i].getDouble(this.aNameData.getValue());
            }
        } else if (this.aggregationType.getValue() == 3) {
            for (int i = 0; i < entities.length; ++i) {
                area = entities[i].getDouble(this.aNameArea.getValue());
                areaSum += area;
                dataSum += entities[i].getDouble(this.aNameData.getValue());
            }
            dataSum /= areaSum;
        } else if (this.aggregationType.getValue() == 4) {
            for (int i = 0; i < entities.length; ++i) {
                area = entities[i].getDouble(this.aNameArea.getValue());
                areaSum += area;
                double data = entities[i].getDouble(this.aNameData.getValue());
                data = data * area / 10000.0;
                dataSum += data;
            }
            dataSum /= areaSum / 10000.0;
        } else if (this.aggregationType.getValue() == 5) {
            for (int i = 0; i < entities.length; ++i) {
                area = entities[i].getDouble(this.aNameArea.getValue());
                areaSum += area;
                double data = entities[i].getDouble(this.aNameData.getValue());
                dataSum += (data *= area);
            }
            dataSum /= areaSum;
        } else if (this.aggregationType.getValue() == 6) {
            for (int i = 0; i < entities.length; ++i) {
                dataSum += entities[i].getDouble(this.aNameData.getValue());
                area = i;
            }
        }
        this.targetEntity.setDouble(this.aNameData.getValue(), dataSum);
    }
}

