/*
 * Decompiled with CFR 0.152.
 */
package hymod;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.io.GenericDataReader;
import org.unijena.jams.io.JAMSTableDataArray;
import org.unijena.jams.io.JAMSTableDataConverter;
import org.unijena.jams.io.JAMSTableDataStore;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="hymod.DataReader", author="Peter Krause", description="Component which reads HYMOD specific data files. Such files should contain columns with date, precip, potential ET and observed runoff for each time step")
public class DataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="A full qualfied file name pointing to a hymodcompliant data file")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Internal variable name for the precipitation value ofeach time step")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Internal variable name for the potential ET value ofeach time step")
    public JAMSDouble pet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Internal variable name for the observed runoff value ofeach time step")
    public JAMSDouble obsRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Time interval of current temporal context")
    public JAMSTimeInterval timeInterval;
    private JAMSTableDataStore store;
    public HashMap dataMap = new HashMap();
    private String[] md;
    private JAMSTableDataArray da;

    public void init() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.fileName.getValue()));
            String line = reader.readLine();
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String desc = strTok.nextToken();
            String start = strTok.nextToken();
            JAMSCalendar startTime = this.parseTime(start);
            line = reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            desc = strTok.nextToken();
            String end = strTok.nextToken();
            JAMSCalendar endTime = this.parseTime(end);
            line = reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            int cols = strTok.countTokens() - 1;
            this.md = new String[cols];
            strTok.nextToken();
            for (int i = 0; i < cols; ++i) {
                this.md[i] = strTok.nextToken();
            }
            this.store = new GenericDataReader(this.fileName.getValue(), true, 1, 4);
            if (this.timeInterval != null) {
                if (this.timeInterval.getStart().before((Object)startTime) || this.timeInterval.getEnd().after((Object)endTime)) {
                    this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.fileName.getValue() + " do not match current temporal context!");
                }
                int timeUnit = this.timeInterval.getTimeUnit();
                JAMSCalendar tiStart = this.timeInterval.getStart();
                JAMSCalendar date = new JAMSCalendar(tiStart.get(1), tiStart.get(2), tiStart.get(5), startTime.get(11), startTime.get(12), startTime.get(13));
                while (startTime.before((Object)date) && this.store.hasNext()) {
                    this.da = this.store.getNext();
                    if (timeUnit == 6) {
                        startTime.add(5, 1);
                        continue;
                    }
                    if (timeUnit == 11) {
                        startTime.add(11, 1);
                        continue;
                    }
                    if (timeUnit != 2) continue;
                    startTime.add(2, 1);
                }
                this.getModel().getRuntime().println(this.fileName.getValue() + " data file initalised ... ", 2);
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
    }

    public void run() {
        JAMSTableDataArray da = this.store.getNext();
        double[] vals = JAMSTableDataConverter.toDouble((JAMSTableDataArray)da);
        for (int i = 0; i < this.md.length; ++i) {
            this.dataMap.put(this.md[i], vals[i]);
        }
        this.precip.setValue(((Double)this.dataMap.get("precip")).doubleValue());
        this.pet.setValue(((Double)this.dataMap.get("pet")).doubleValue());
        this.obsRunoff.setValue(((Double)this.dataMap.get("runoff")).doubleValue());
    }

    public void cleanup() {
        this.store.close();
    }

    private JAMSCalendar parseTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        JAMSCalendar cal = new JAMSCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0]);
        return cal;
    }
}

