/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.GraphProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class JAMSTimePlot {
    Vector<GraphProperties> propVector;
    DateAxis dateAxis;
    ValueAxis axisLEFT;
    ValueAxis axisRIGHT;
    int graphCount = 0;
    int graphCountRight = 0;
    int graphCountLeft = 0;
    String xAxisTitle;
    String leftAxisTitle;
    String rightAxisTitle;
    String title;
    ChartPanel chartPanel;
    TimeSeriesCollection dataLeft = new TimeSeriesCollection();
    TimeSeriesCollection dataRight = new TimeSeriesCollection();
    XYItemRenderer rightRenderer;
    XYItemRenderer leftRenderer;
    XYPlot plot;
    JFreeChart chart;
    JPanel panel;
    JButton saveButton;
    HashMap<String, Color> colorTable = new HashMap();

    public JAMSTimePlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.setDefaultValues();
    }

    public JAMSTimePlot(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        String xAxisTitle = "x axis title";
        String leftAxisTitle = "left axis title";
        String rightAxisTitle = "right axis title";
        String title = "CTSPlot ver. 0.10";
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private XYItemRenderer getRenderer(int type) {
        XYBarRenderer r;
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
                break;
            }
            case 1: {
                r = new XYBarRenderer();
                break;
            }
            case 2: {
                r = new XYAreaRenderer();
                break;
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                r = lsr;
                break;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                r = dotR;
                break;
            }
            case 5: {
                r = new XYDifferenceRenderer();
                break;
            }
            case 6: {
                r = new XYStepRenderer();
                break;
            }
            case 7: {
                r = new XYStepAreaRenderer();
                break;
            }
            default: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
            }
        }
        return r;
    }

    public void createPlot() {
        this.chart = ChartFactory.createTimeSeriesChart((String)"title", (String)"xAxisTitle", (String)"leftAxisTitle", (XYDataset)this.dataLeft, (boolean)true, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, true);
        this.chartPanel.setBackground(Color.WHITE);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 1));
        this.panel.add((Component)this.chartPanel);
        this.plot = this.chart.getXYPlot();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
        this.axisLEFT = this.plot.getRangeAxis();
        this.axisRIGHT = new NumberAxis(this.rightAxisTitle);
    }

    public void setPropVector(Vector<GraphProperties> propVector) {
        this.propVector = propVector;
    }

    public Vector<GraphProperties> getPropVector() {
        return this.propVector;
    }

    public void plotLeft(int renderer, String nameLeft, String xAxisTitle, boolean inverted) {
        int c = this.propVector.size();
        int corr = 0;
        this.dataLeft = new TimeSeriesCollection();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        this.axisLEFT.setInverted(inverted);
        this.axisLEFT.setLabel(nameLeft);
        dateAxis.setLabel(xAxisTitle);
        this.leftRenderer = this.getRenderer(renderer);
        for (int k = 0; k < c; ++k) {
            if (this.propVector.get(k).getPosChoice().getSelectedItem() == "left") {
                GraphProperties prop = this.propVector.get(k);
                this.dataLeft.addSeries(prop.getTS());
                if (k - corr <= this.dataRight.getSeriesCount()) {
                    this.dataRight.removeSeries(prop.getTS());
                }
                this.leftRenderer.setSeriesPaint(k - corr, (Paint)this.colorTable.get((String)prop.getColorChoice().getSelectedItem()));
                continue;
            }
            ++corr;
        }
        this.plot.setRangeAxis(0, this.axisLEFT);
        this.plot.setDataset(0, (XYDataset)this.dataLeft);
        this.plot.setRenderer(0, this.leftRenderer);
        this.plot.mapDatasetToRangeAxis(1, 1);
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void plotRight(int renderer, String nameRight, String xAxisTitle, boolean inverted) {
        int c = this.propVector.size();
        int corr = 0;
        this.dataRight = new TimeSeriesCollection();
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        this.axisRIGHT.setInverted(inverted);
        this.axisRIGHT.setLabel(nameRight);
        dateAxis.setLabel(xAxisTitle);
        this.rightRenderer = this.getRenderer(renderer);
        for (int k = 0; k < c; ++k) {
            if (this.propVector.get(k).getPosChoice().getSelectedItem() == "right") {
                GraphProperties prop = this.propVector.get(k);
                this.dataRight.addSeries(prop.getTS());
                if (k - corr <= this.dataLeft.getSeriesCount()) {
                    this.dataLeft.removeSeries(prop.getTS());
                }
                this.rightRenderer.setSeriesPaint(k - corr, (Paint)this.colorTable.get((String)prop.getColorChoice().getSelectedItem()));
                continue;
            }
            ++corr;
        }
        this.plot.setRangeAxis(1, this.axisRIGHT);
        this.plot.setDataset(1, (XYDataset)this.dataRight);
        this.plot.setRenderer(1, this.rightRenderer);
        this.plot.mapDatasetToRangeAxis(1, 1);
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
    }

    public void cleanup() {
    }
}

