/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFactorySpi;
import org.geotools.data.coverage.grid.UnknownFormat;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.opengis.coverage.grid.Format;

public final class GridFormatFinder {
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GridFormatFinder() {
    }

    public static synchronized Set getAvailableFormats() {
        Iterator it = GridFormatFinder.getServiceRegistry().getServiceProviders(GridFormatFactorySpi.class);
        HashSet<GridFormatFactorySpi> formats = new HashSet<GridFormatFactorySpi>(5);
        while (it.hasNext()) {
            GridFormatFactorySpi spi = (GridFormatFactorySpi)it.next();
            if (!spi.isAvailable()) continue;
            formats.add(spi);
        }
        return Collections.unmodifiableSet(formats);
    }

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(GridFormatFinder.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(GridFormatFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        GridFormatFinder.getServiceRegistry().scanForPlugins();
    }

    public static Format[] getFormatArray() {
        Set formats = GridFormatFinder.getAvailableFormats();
        ArrayList<Format> formatSet = new ArrayList<Format>(formats.size());
        Iterator iter = formats.iterator();
        while (iter.hasNext()) {
            GridFormatFactorySpi element = (GridFormatFactorySpi)iter.next();
            formatSet.add(element.createFormat());
        }
        return formatSet.toArray(new Format[formatSet.size()]);
    }

    public static synchronized Set findFormats(Object o) {
        Set availaibleFormats = GridFormatFinder.getAvailableFormats();
        HashSet<Format> formats = new HashSet<Format>();
        Iterator it = availaibleFormats.iterator();
        Format retVal = null;
        GridFormatFactorySpi spi = null;
        while (it.hasNext()) {
            spi = (GridFormatFactorySpi)it.next();
            retVal = spi.createFormat();
            if (!(retVal instanceof AbstractGridFormat) || !((AbstractGridFormat)retVal).accepts(o)) continue;
            formats.add(retVal);
        }
        return Collections.unmodifiableSet(formats);
    }

    public static synchronized Format findFormat(Object o) {
        Set formats = GridFormatFinder.findFormats(o);
        Iterator it = formats.iterator();
        if (it.hasNext()) {
            return (Format)it.next();
        }
        return new UnknownFormat();
    }

    static {
        $assertionsDisabled = !GridFormatFinder.class.desiredAssertionStatus();
    }
}

