/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeReader;
import org.geotools.feature.AttributeType;

public class JoiningAttributeReader
implements AttributeReader {
    private AttributeReader[] readers;
    private int[] index;
    private AttributeType[] metaData;

    public JoiningAttributeReader(AttributeReader[] readers) {
        this.readers = readers;
        this.metaData = this.joinMetaData(readers);
    }

    private AttributeType[] joinMetaData(AttributeReader[] readers) {
        int total = 0;
        this.index = new int[readers.length];
        int ii = readers.length;
        for (int i = 0; i < ii; ++i) {
            this.index[i] = total;
            total += readers[i].getAttributeCount();
        }
        AttributeType[] md = new AttributeType[total];
        int idx = 0;
        int ii2 = readers.length;
        for (int i = 0; i < ii2; ++i) {
            int jj = readers[i].getAttributeCount();
            for (int j = 0; j < jj; ++j) {
                md[idx] = readers[i].getAttributeType(j);
                ++idx;
            }
        }
        return md;
    }

    public void close() throws IOException {
        IOException dse = null;
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            try {
                this.readers[i].close();
                continue;
            }
            catch (IOException e) {
                dse = e;
            }
        }
        if (dse != null) {
            throw dse;
        }
    }

    public boolean hasNext() throws IOException {
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.readers[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    public void next() throws IOException {
        int ii = this.readers.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.readers[i].hasNext()) continue;
            this.readers[i].next();
        }
    }

    public Object read(int idx) throws IOException {
        AttributeReader reader = null;
        for (int i = this.index.length - 1; i >= 0; --i) {
            if (idx < this.index[i]) continue;
            idx -= this.index[i];
            reader = this.readers[i];
            break;
        }
        if (reader == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return reader.read(idx);
    }

    public int getAttributeCount() {
        return this.metaData.length;
    }

    public AttributeType getAttributeType(int i) {
        return this.metaData[i];
    }
}

