/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class CollectionFeatureReader
implements FeatureReader {
    private FeatureCollection collection;
    private Iterator features;
    private FeatureType type;
    private boolean closed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CollectionFeatureReader(Collection featuresArg, FeatureType typeArg) {
        if (!$assertionsDisabled && featuresArg.isEmpty()) {
            throw new AssertionError();
        }
        if (featuresArg instanceof FeatureCollection) {
            this.collection = (FeatureCollection)featuresArg;
        }
        this.features = featuresArg.iterator();
        this.type = typeArg;
    }

    public CollectionFeatureReader(FeatureCollection featuresArg, FeatureType typeArg) {
        if (!$assertionsDisabled && featuresArg.isEmpty()) {
            throw new AssertionError();
        }
        this.collection = featuresArg;
        this.features = featuresArg.iterator();
        this.type = typeArg;
    }

    public CollectionFeatureReader(Feature[] featuresArg) {
        if (!$assertionsDisabled && featuresArg.length <= 0) {
            throw new AssertionError();
        }
        this.features = Arrays.asList(featuresArg).iterator();
        this.type = featuresArg[0].getFeatureType();
    }

    public FeatureType getFeatureType() {
        return this.type;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.closed) {
            throw new NoSuchElementException("Reader has been closed");
        }
        return (Feature)this.features.next();
    }

    public boolean hasNext() throws IOException {
        return this.features.hasNext() && !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.collection != null) {
            this.collection.close(this.features);
        }
    }

    static {
        $assertionsDisabled = !CollectionFeatureReader.class.desiredAssertionStatus();
    }
}

