/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.physicalCalculations;

public class SolarRadiationCalculationMethods {
    public static double calc_SunDeclination(int julDay) {
        double declination = 0.40954 * Math.sin(0.0172 * ((double)julDay - 79.35));
        return declination;
    }

    public static double calc_SolarConstant(int julDay) {
        double S = 81930.0 + 2910.0 * Math.cos(Math.PI / 180 * (double)(julDay - 15));
        return S /= 1000000.0;
    }

    public static double calc_InverseRelativeDistanceEarthSun(int julDay) {
        double irdes = 1.0 + 0.033 * Math.cos(0.01721420632103996 * (double)julDay);
        return irdes;
    }

    public static double calc_SolarRadiation(double s, double s0, double Ra, double angstrom_a, double angstrom_b) {
        double Rs = s0 > 0.0 ? (angstrom_a + angstrom_b * (s / s0)) * Ra : 0.0;
        return Rs;
    }

    public static double calc_NetShortwaveRadiation(double albedo, double Rs) {
        double Rns = (1.0 - albedo) * Rs;
        return Rns;
    }

    public static double calc_NetRadiation(double Rns, double Rnl) {
        double Rn = Rns - Rnl;
        if (Rn < 0.0) {
            Rn = 0.0;
        }
        return Rn;
    }

    public static double calc_ClearSkySolarRadiation(double elevation, double Ra) {
        double cssr = (0.75 + 2.0E-5 * elevation) * Ra;
        return cssr;
    }
}

