/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSTimeInterval;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Time series capturer", author="Peter Krause", description="Saves time series in the memory for later processinge.g. plotting, efficiency calculation or whatever")
public class TimeSeriesCapturer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The model time interval")
    public JAMSTimeInterval modelTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The time interval to capture")
    public JAMSTimeInterval captureTimeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="The months to be captured")
    public JAMSIntegerArray captureMonthList;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the timeSeries values to capture")
    public JAMSDouble timeSeriesVal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="the captured time series")
    public JAMSDoubleArray timeSeries = new JAMSDoubleArray();
    private final int TOTAL_PERIOD = 0;
    private final int HYDROLOGICAL_YEAR = 1;
    private final int CALENDAR_YEAR = 2;
    private double[] captData;
    private int counter = 0;
    private int interValStart = 0;
    private int interValEnd = 0;
    private int effTsteps = 0;
    private boolean monthly = false;
    private int monthCount = 0;

    public void init() {
        this.counter = 0;
        this.monthCount = 0;
        JAMSCalendar model_sd = this.modelTimeInterval.getStart().clone();
        JAMSCalendar model_ed = this.modelTimeInterval.getEnd().clone();
        int model_tres = this.modelTimeInterval.getTimeUnit();
        long sdMod = model_sd.getTimeInMillis();
        long edMod = model_ed.getTimeInMillis();
        long model_tsteps = 0L;
        model_tsteps = this.modelTimeInterval.getNumberOfTimesteps();
        JAMSCalendar eff_sd = this.captureTimeInterval.getStart().clone();
        JAMSCalendar eff_ed = this.captureTimeInterval.getEnd().clone();
        int eff_tres = this.captureTimeInterval.getTimeUnit();
        long sdEff = eff_sd.getTimeInMillis();
        long edEff = eff_ed.getTimeInMillis();
        if (eff_sd.before((Object)model_sd)) {
            this.captureTimeInterval.setStart(model_sd);
            this.getModel().getRuntime().println("capture Startdate was set equal to model startdate", 1);
        }
        if (model_ed.before((Object)eff_ed)) {
            this.captureTimeInterval.setEnd(model_ed);
            this.getModel().getRuntime().println("capture Enddate was set equal to model enddate", 1);
        }
        this.effTsteps = (int)this.captureTimeInterval.getNumberOfTimesteps();
        int ts = (int)this.getContext().getNumberOfIterations();
        this.getModel().getRuntime().println("effStartdate:\t" + eff_sd.toString(), 2);
        this.getModel().getRuntime().println("effEnddate:\t" + eff_ed.toString(), 2);
        this.captData = new double[this.effTsteps];
        this.counter = 0;
        if (eff_tres == 6) {
            this.interValStart = (int)((sdEff - sdMod) / 86400000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 11) {
            this.interValStart = (int)((sdEff - sdMod) / 3600000L);
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 2) {
            JAMSCalendar modStart = this.modelTimeInterval.getStart().clone();
            JAMSCalendar effStart = this.captureTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before((Object)effStart)) {
                ++startStep;
                modStart.add(2, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        } else if (eff_tres == 1) {
            JAMSCalendar modStart = this.modelTimeInterval.getStart().clone();
            JAMSCalendar effStart = this.captureTimeInterval.getStart().clone();
            int startStep = 0;
            while (modStart.before((Object)effStart)) {
                ++startStep;
                modStart.add(1, 1);
            }
            this.interValStart = startStep;
            this.interValEnd = this.interValStart + this.effTsteps;
        }
        boolean junk = false;
        if (this.captureMonthList != null) {
            this.monthly = true;
        }
        this.timeSeries.setValue(this.captData);
    }

    public void run() {
        this.captData = this.timeSeries.getValue();
        boolean capture = false;
        if (this.time.equals((Object)this.captureTimeInterval.getStart())) {
            capture = true;
        } else if (this.time.after((Object)this.captureTimeInterval.getStart())) {
            if (this.time.before((Object)this.captureTimeInterval.getEnd())) {
                capture = true;
            }
        } else if (this.time.equals((Object)this.captureTimeInterval.getEnd())) {
            capture = true;
        }
        if (capture) {
            if (this.monthly) {
                int month = this.time.get(2) + 1;
                for (int i = 0; i < this.captureMonthList.getValue().length; ++i) {
                    if (month != this.captureMonthList.getValue()[i]) continue;
                    this.captData[this.counter] = this.timeSeriesVal.getValue();
                    ++this.counter;
                    ++this.monthCount;
                }
            } else {
                this.captData[this.counter] = this.timeSeriesVal.getValue();
                ++this.counter;
            }
            this.timeSeries.setValue(this.captData);
        }
    }

    public void cleanup() {
    }
}

