/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.j2k.statistics.IDW;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="RainCorrection_Richter", author="Peter Krause", description="Applies correction according to RICHTER 1985 for measured daily precip sums")
public class RainCorrectionRichter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the precip values")
    public JAMSDoubleArray precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="temperature for the correction function")
    public JAMSDoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="corrected precip values")
    public JAMSDoubleArray rcorr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station elevations")
    public JAMSDoubleArray tempElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's x coordinate")
    public JAMSDoubleArray tempXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's y coordinate")
    public JAMSDoubleArray tempYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Regression coefficients for temperature")
    public JAMSDoubleArray tempRegCoeff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of precip station elevations")
    public JAMSDoubleArray rainElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of precip station's x coordinate")
    public JAMSDoubleArray rainXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of precip station's y coordinate")
    public JAMSDoubleArray rainYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="number of temperature station for IDW")
    public JAMSInteger tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="power for IDW function")
    public JAMSDouble pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="regression threshold")
    public JAMSDouble regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow_trs")
    public JAMSDouble snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="snow_trans")
    public JAMSDouble snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (!this.dataCaching.getValue()) {
            int i;
            double[] precip = this.precip.getValue();
            double[] temperature = this.temperature.getValue();
            double[] rcorr = new double[precip.length];
            double[] rainElev = new double[precip.length];
            double[] rainX = new double[precip.length];
            double[] rainY = new double[precip.length];
            double[][] statWeights = new double[precip.length][temperature.length];
            for (i = 0; i < precip.length; ++i) {
                rainElev[i] = this.rainElevation.getValue()[i];
                rainX[i] = this.rainXCoord.getValue()[i];
                rainY[i] = this.rainYCoord.getValue()[i];
                for (int n = 0; n < this.tempNIDW.getValue(); ++n) {
                    statWeights[i][n] = 0.0;
                }
            }
            for (i = 0; i < rcorr.length; ++i) {
                statWeights[i] = IDW.calcNidwWeights(rainX[i], rainY[i], this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.pIDW.getValue(), this.tempNIDW.getValue());
            }
            double rsq = this.tempRegCoeff.getValue()[2];
            double grad = this.tempRegCoeff.getValue()[1];
            for (int r = 0; r < rcorr.length; ++r) {
                double rainTemp = 0.0;
                for (int t = 0; t < temperature.length; ++t) {
                    if (rsq >= this.regThres.getValue()) {
                        double deltaElev = this.rainElevation.getValue()[r] - this.tempElevation.getValue()[t];
                        rainTemp += (deltaElev * grad + temperature[t]) * statWeights[r][t];
                        continue;
                    }
                    rainTemp += temperature[t] * statWeights[r][t];
                }
                double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - rainTemp) / (2.0 * this.snow_trans.getValue());
                if (pSnow > 1.0) {
                    pSnow = 1.0;
                } else if (pSnow < 0.0) {
                    pSnow = 0.0;
                }
                double rain = (1.0 - pSnow) * precip[r];
                double snow = pSnow * precip[r];
                double windErr = 0.0;
                if (snow > 0.0) {
                    if (snow <= 0.1) {
                        snow += snow * 0.938;
                    } else {
                        double relSnow = 0.5319 * Math.pow(snow, -0.197);
                        snow += snow * relSnow;
                    }
                }
                if (rain > 0.0) {
                    rain = rain < 0.1 ? (rain += precip[r] * 0.492) : (rain += precip[r] * (0.1349 * Math.pow(precip[r], -0.494)));
                }
                double wetErr = 0.0;
                wetErr = precip[r] < 0.1 ? 0.0 : (this.time.get(2) >= 4 & this.time.get(2) < 10 ? (precip[r] >= 9.0 ? 0.47 : 0.08 * Math.log(precip[r]) + 0.225) : (precip[r] >= 9.0 ? 0.3 : 0.05 * Math.log(precip[r]) + 0.13));
                rcorr[r] = rain + snow + wetErr;
            }
            this.rcorr.setValue(rcorr);
        }
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

