/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import java.util.ArrayList;
import org.unijena.hydronet.CostNeuron;
import org.unijena.hydronet.DistNeuron;
import org.unijena.hydronet.GenericFunction;
import org.unijena.hydronet.LinApprox;
import org.unijena.hydronet.Matrix;
import org.unijena.hydronet.NONeuron;
import org.unijena.hydronet.Neuron;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class HydroNETCreator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntity NitrogenOutEntity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntity CostOutEntity;
    DistNeuron NitrogenOutNeuron = new DistNeuron();
    DistNeuron CostOutNeuron = new DistNeuron();

    public void init() throws JAMSEntity.NoSuchAttributeException {
        ArrayList list = new ArrayList();
        this.getModel().getRuntime().println("Setup HydroNET");
        this.NitrogenOutNeuron.setSizeOfArea(1.0);
        this.CostOutNeuron.setSizeOfArea(1.0);
        Matrix M2 = new Matrix(2, 2);
        M2.element[0][0] = -100.0;
        M2.element[0][1] = 0.0;
        M2.element[1][0] = 100.0;
        M2.element[1][1] = -0.0;
        LinApprox lin_id2 = new LinApprox(M2);
        GenericFunction gen_id2 = new GenericFunction(lin_id2);
        for (int i = this.hrus.getEntities().size() - 1; i >= 0; --i) {
            JAMSEntity e = (JAMSEntity)this.hrus.getEntities().get(i);
            e.setDouble("reduction", 0.0);
            NONeuron nitr_neuron = new NONeuron();
            nitr_neuron.addFilter((GenericFunction)e.getObject("ActivationFunction"));
            nitr_neuron.setID((long)e.getDouble("ID"));
            JAMSEntity downstreamPoly = (JAMSEntity)e.getObject("to_poly");
            if (downstreamPoly == null) {
                nitr_neuron.setDownstreamNeuron(null, 0.0);
                nitr_neuron.setOutputNeuron(this.NitrogenOutNeuron, 1.0);
            } else {
                Neuron downstream_neuron = (Neuron)downstreamPoly.getObject("NITROGEN_NEURON");
                if (downstream_neuron == null) {
                    this.getModel().getRuntime().println("WARNING: Downstream Neuron = Null");
                }
                nitr_neuron.setDownstreamNeuron(downstream_neuron, e.getDouble("interflow_weight"));
                nitr_neuron.setOutputNeuron(this.NitrogenOutNeuron, e.getDouble("percolation_weight"));
            }
            e.setObject("NITROGEN_NEURON", (Object)nitr_neuron);
            CostNeuron cost_neuron = new CostNeuron();
            cost_neuron.setSizeOfArea(e.getDouble("area"));
            cost_neuron.addFilter(gen_id2);
            CostNeuron.setCostFactor(1.0);
            cost_neuron.setOutputNeuron(this.CostOutNeuron);
            cost_neuron.setID((long)e.getDouble("ID"));
            e.setObject("COST_NEURON", (Object)cost_neuron);
            DistNeuron dist_neuron = new DistNeuron();
            dist_neuron.setCostNeuron(cost_neuron);
            dist_neuron.setNitrNeuron(nitr_neuron);
            dist_neuron.setInitialExternInput(e.getDouble("ist_input"));
            dist_neuron.setMaxInput(e.getDouble("ist_input"));
            dist_neuron.setMinInput(e.getDouble("min_input"));
            dist_neuron.setID((long)e.getDouble("ID"));
            e.setObject("DIST_NEURON", (Object)dist_neuron);
            this.NitrogenOutEntity.setObject("NEURON", (Object)this.NitrogenOutNeuron);
            this.CostOutEntity.setObject("NEURON", (Object)this.CostOutNeuron);
        }
    }
}

