/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Lock {
    Logger logger = Logger.getLogger("org.geotools.data.shapefile");
    int writeLocks = 0;
    Thread writer;
    Map owners = new HashMap();

    synchronized boolean canRead() throws IOException {
        if (this.writer != null && this.writer != Thread.currentThread()) {
            return false;
        }
        if (this.writer == null) {
            return true;
        }
        return this.owners.size() <= 1;
    }

    synchronized boolean canWrite() throws IOException {
        if (this.owners.size() > 1) {
            return false;
        }
        if (this.canRead() && (this.writer == Thread.currentThread() || this.writer == null)) {
            if (this.owners.isEmpty()) {
                return true;
            }
            if (this.owners.containsKey(Thread.currentThread())) {
                return true;
            }
        }
        return false;
    }

    public synchronized void lockRead() throws IOException {
        if (!this.canRead()) {
            while (this.writeLocks > 0 || this.writer != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
        }
        this.assertTrue("A write lock exists that is owned by another thread", this.canRead());
        Thread current = Thread.currentThread();
        Owner owner = (Owner)this.owners.get(current);
        if (owner != null) {
            ++owner.timesLocked;
        } else {
            owner = new Owner(current);
            this.owners.put(current, owner);
        }
        this.logger.finer("Start Read Lock:" + owner);
    }

    private void assertTrue(String message, boolean b) {
        if (!b) {
            throw new AssertionError((Object)message);
        }
    }

    public synchronized void unlockRead() {
        this.assertTrue("Current thread does not have a readLock", this.owners.containsKey(Thread.currentThread()));
        Owner owner = (Owner)this.owners.get(Thread.currentThread());
        this.assertTrue("Current thread has " + owner.timesLocked + "negative number of locks", owner.timesLocked > 0);
        --owner.timesLocked;
        if (owner.timesLocked == 0) {
            this.owners.remove(Thread.currentThread());
        }
        this.notifyAll();
        this.logger.finer("unlock Read:" + owner);
    }

    public synchronized void lockWrite() throws IOException {
        Thread currentThread = Thread.currentThread();
        if (this.writer == null) {
            this.writer = currentThread;
        }
        while (!this.canWrite()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException().initCause(e);
            }
            if (this.writer != null) continue;
            this.writer = currentThread;
        }
        if (this.writer == null) {
            this.writer = currentThread;
        }
        this.assertTrue("The current thread is not the writer", this.writer == currentThread);
        this.assertTrue("There are read locks not belonging to the current thread.", this.canRead());
        ++this.writeLocks;
        this.logger.finer(currentThread.getName() + " is getting write lock:" + this.writeLocks);
    }

    synchronized int getReadLocks(Thread thread) {
        Owner owner = (Owner)this.owners.get(thread);
        if (owner == null) {
            return -1;
        }
        return owner.timesLocked;
    }

    public synchronized void unlockWrite() {
        if (this.writeLocks > 0) {
            this.assertTrue("current thread does not own the write lock", this.writer == Thread.currentThread());
            this.assertTrue("writeLock has already been unlocked", this.writeLocks > 0);
            --this.writeLocks;
            if (this.writeLocks == 0) {
                this.writer = null;
            }
        }
        this.logger.finer("unlock write:" + Thread.currentThread().getName());
        this.notifyAll();
    }

    synchronized boolean ownWriteLock(Thread thread) {
        return this.writer == thread && this.writeLocks > 0;
    }

    private class Owner {
        final Thread owner;
        int timesLocked;

        Owner(Thread owner) {
            this.owner = owner;
            this.timesLocked = 1;
        }

        public String toString() {
            return this.owner.getName() + " has " + this.timesLocked + " locks";
        }
    }
}

