/*
 * Decompiled with CFR 0.152.
 */
package rbis.datastore;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSTimeInterval;
import rbis.datastore.DataSource;

public class IndexSource
extends DataSource {
    JAMSTimeInterval timeInterval;
    int startIndex;
    int counter;

    @Override
    public boolean init() {
        this.counter = 0;
        this.startIndex = 0;
        if (this.parameter.containsKey("timeInterval")) {
            this.timeInterval = new JAMSTimeInterval();
            this.timeInterval.setValue((String)this.parameter.get("timeInterval"));
        } else {
            this.startIndex = this.parameter.containsKey("startIndex") ? Integer.parseInt((String)this.parameter.get("startIndex")) : 0;
        }
        return true;
    }

    @Override
    public Object[] getNext() {
        if (this.timeInterval != null) {
            Object[] o = new JAMSCalendar[]{this.timeInterval.getStart().clone()};
            o[0].add(this.timeInterval.getTimeUnit(), this.counter);
            ++this.counter;
            return o;
        }
        Object[] o = new JAMSInteger[]{new JAMSInteger()};
        o[0].setValue(this.startIndex + this.counter);
        ++this.counter;
        return o;
    }

    @Override
    public boolean hasNext() {
        if (this.timeInterval != null) {
            return (long)this.counter < this.timeInterval.getNumberOfTimesteps();
        }
        return true;
    }
}

