/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.LinkedHashSet;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.util.Cloneable;

public class CheckedHashSet
extends LinkedHashSet
implements Cloneable {
    private static final long serialVersionUID = -9014541457174735097L;
    private final Class type;

    public CheckedHashSet(Class type) {
        this.type = type;
        if (type == null) {
            throw new NullPointerException(Errors.format(105, "type"));
        }
    }

    protected void ensureValidType(Object element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format(45, Utilities.getShortClassName(element), Utilities.getShortName(this.type)));
        }
    }

    public boolean add(Object element) {
        this.ensureValidType(element);
        return super.add(element);
    }
}

