/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_salt_init;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KNaClSoillayer", author="Manfred Fink", description="intitiallizing NaCl Pools in Soil and additional variables")
public class InitJ2KNaClSoillayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDoubleArray soil_bulk_density = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" in % organic Carbon in soil")
    public JAMSDoubleArray C_org = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDoubleArray NaCl_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDoubleArray Residue_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDoubleArray NaCl_residue_pool_fresh = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSDoubleArray InterflowNaCl_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Input of plant residues kg/ha")
    public JAMSDouble inp_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen input of plant residues in kgN/ha")
    public JAMSDouble inpNaCl_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="number of layers in soil profile in [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="flag plant existing yes or no ")
    public JAMSBoolean plantExisting = new JAMSBoolean();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" state variable LAI in [-]")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual rooting depth [dm]")
    public JAMSDouble ZRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual salt uptake by plants in kgNaCl/ha")
    public JAMSDouble actNaCl_up;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int layer = (int)this.Layer.getValue();
        this.plantExisting.setValue(true);
        double hor_dept = 0.0;
        double[] NaCl_Poolvals = new double[layer];
        double[] NaCl_residue_pool_freshvals = new double[layer];
        double[] Residue_poolvals = new double[layer];
        double[] InterflowNaCl_invals = new double[layer];
        for (int i = 0; i < layer; ++i) {
            double runC_org = this.C_org.getValue()[i];
            double runsoil_bulk_density = this.soil_bulk_density.getValue()[i];
            double runlayerdepth = this.layerdepth.getValue()[i] * 10.0;
            double runResidue_pool = 10.0;
            double runNaCl_Pool = 7.0 * Math.exp(-(hor_dept += runlayerdepth) / 1000.0) * runsoil_bulk_density * runlayerdepth / 1000.0;
            double runNaCl_residue_pool_fresh = 0.0015 * runResidue_pool;
            NaCl_Poolvals[i] = runNaCl_Pool;
            Residue_poolvals[i] = runResidue_pool;
            NaCl_residue_pool_freshvals[i] = runNaCl_residue_pool_fresh;
            InterflowNaCl_invals[i] = 0.0;
        }
        this.NaCl_Pool.setValue(NaCl_Poolvals);
        this.Residue_pool.setValue(Residue_poolvals);
        this.NaCl_residue_pool_fresh.setValue(NaCl_residue_pool_freshvals);
        this.InterflowNaCl_in.setValue(InterflowNaCl_invals);
        this.inp_biomass.setValue(0.0);
        this.inpNaCl_biomass.setValue(0.0);
        this.LAI.setValue(0.0);
        this.ZRootD.setValue(0.0);
        this.actNaCl_up.setValue(0.0);
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

