/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.io;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardCropParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Crop parameter file name")
    public JAMSString crFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection crops = new JAMSEntityCollection();
        crops.setEntities(J2KFunctions.readParas((String)(this.dirName.getValue() + "/" + this.crFileName.getValue()), (JAMSModel)this.getModel()));
        HashMap<Double, JAMSEntity> crMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity cr : crops.getEntities()) {
            crMap.put(cr.getDouble("CID"), cr);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity cr;
            cr = (JAMSEntity)crMap.get(e.getDouble("cropID"));
            e.setObject("crop", (Object)cr);
            Object[] attrs = cr.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                e.setDouble((String)attrs[i], cr.getDouble((String)attrs[i]));
            }
        }
    }
}

