/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSModel;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardLMPastureParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Pasture management parameter file name")
    public JAMSString lpFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection lmpas = new JAMSEntityCollection();
        lmpas.setEntities(J2KFunctions.readParas((String)(this.dirName.getValue() + "/" + this.lpFileName.getValue()), (JAMSModel)this.getModel()));
        HashMap<Double, JAMSEntity> lpMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity lp : lmpas.getEntities()) {
            lpMap.put(lp.getDouble("ID"), lp);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity lp;
            lp = (JAMSEntity)lpMap.get(e.getDouble("lmpasID"));
            e.setObject("lmPas", (Object)lp);
            Object[] attrs = lp.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                e.setDouble((String)attrs[i], lp.getDouble((String)attrs[i]));
            }
        }
    }
}

