/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessReachRouting_N", author="c0krpe & Manfred Fink", description="Reach Routing of Water and Nitrogen to replace J2KProcessReachRouting")
public class J2KProcessReachRouting_N
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The reach collection")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute length")
    public JAMSDouble length;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute width")
    public JAMSDouble width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute roughness")
    public JAMSDouble roughness;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 inflow")
    public JAMSDouble inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 inflow")
    public JAMSDouble inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 outflow")
    public JAMSDouble outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 outflow")
    public JAMSDouble outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar simulated Runoff")
    public JAMSDouble simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1 storage")
    public JAMSDouble actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2 storage")
    public JAMSDouble actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Channel storage")
    public JAMSDouble channelStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="flow routing coefficient TA")
    public JAMSDouble flowRouteTA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="SurfaceN outflow in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="(fast) InterflowN outflow in kgN")
    public JAMSDouble InterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="(slow) InterflowN outflow in kgN")
    public JAMSDouble N_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="GoundwaterN outflow in kgN")
    public JAMSDouble N_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD1_N (SurfaceN) storage in kgN")
    public JAMSDouble ActRD1_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RD2_N ((fast) InterflowN) storage in kgN")
    public JAMSDouble ActRD2_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG1_N ((slow) InterflowN) storage in kgN")
    public JAMSDouble ActRG1_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach statevar RG2_N (GoundwaterN) storage in kgN")
    public JAMSDouble ActRG2_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reach Channel storage N in kgN")
    public JAMSDouble ChannelStorage_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Simulated N Runoff in kgN")
    public JAMSDouble SimRunoff_N;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="SurfaceN inflow in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(fast) InterflowN inflow in kgN")
    public JAMSDouble InterflowN_sum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="(slow) InterflowN inflow in kgN")
    public JAMSDouble N_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="GoundwaterN inflow in kgN")
    public JAMSDouble N_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD1 storage")
    public JAMSDouble catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RD2 storage")
    public JAMSDouble catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG1 storage")
    public JAMSDouble catchmentRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet RG2 storage")
    public JAMSDouble catchmentRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet sim runoff")
    public JAMSDouble catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRD1 storage")
    public JAMSDouble catchmentNRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRD2 storage")
    public JAMSDouble catchmentNRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRG1 storage")
    public JAMSDouble catchmentNRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet NRG2 storage")
    public JAMSDouble catchmentNRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet sim Nitrogen runoff")
    public JAMSDouble catchmentSimRunoffN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Catchment outlet sim Nitrogen runoff")
    public JAMSDouble catchmentSimNconc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="switch whether deep sink is allowed or not")
    public JAMSDouble deepsink;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="amount of water lost by deep sink in l/d")
    public JAMSDouble DeepsinkW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="amount of nitrogen lost by deep sink in kg/d")
    public JAMSDouble DeepsinkN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="K-Value for the riverbed in cm/d")
    public JAMSDouble Ksink;
    private double depth;
    private double rh;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double RG2DestIn_N;
        double RG1DestIn_N;
        double RD2DestIn_N;
        double RD1DestIn_N;
        double RG2DestIn;
        double RG1DestIn;
        double RD2DestIn;
        double RD1DestIn;
        JAMSEntity entity = this.entities.getCurrent();
        JAMSEntity DestReach = (JAMSEntity)entity.getObject("to_reach");
        double deepsinkW = 0.0;
        double deepsinkN = 0.0;
        double Larea = 0.0;
        double width = this.width.getValue();
        double slope = this.slope.getValue();
        double rough = this.roughness.getValue();
        double length = this.length.getValue();
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        double RD1act_N = this.ActRD1_N.getValue() + this.SurfaceN_in.getValue();
        double RD2act_N = this.ActRD2_N.getValue() + this.InterflowN_sum.getValue();
        double RG1act_N = this.ActRG1_N.getValue() + this.N_RG1_in.getValue();
        double RG2act_N = this.ActRG2_N.getValue() + this.N_RG2_in.getValue();
        this.depth = 0.0;
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        this.SurfaceN_in.setValue(0.0);
        this.InterflowN_sum.setValue(0.0);
        this.N_RG1_in.setValue(0.0);
        this.N_RG2_in.setValue(0.0);
        this.ActRD1_N.setValue(0.0);
        this.ActRD2_N.setValue(0.0);
        this.ActRG1_N.setValue(0.0);
        this.ActRG2_N.setValue(0.0);
        if (entity.getObject("to_reach") == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
            RD1DestIn_N = 0.0;
            RD2DestIn_N = 0.0;
            RG1DestIn_N = 0.0;
            RG2DestIn_N = 0.0;
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
            RD1DestIn_N = DestReach.getDouble("SurfaceN_in");
            RD2DestIn_N = DestReach.getDouble("InterflowN_sum");
            RG1DestIn_N = DestReach.getDouble("N_RG1_in");
            RG2DestIn_N = DestReach.getDouble("N_RG2_in");
        }
        double q_act_tot = RD1act + RD2act + RG1act + RG2act;
        double q_act_tot_N = RD1act_N + RD2act_N + RG1act_N + RG2act_N;
        if (q_act_tot == 0.0) {
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.SurfaceNabs.setValue(0.0);
            this.InterflowNabs.setValue(0.0);
            this.N_RG1_out.setValue(0.0);
            this.N_RG2_out.setValue(0.0);
            return;
        }
        double RD1_part = RD1act / q_act_tot;
        double RD2_part = RD2act / q_act_tot;
        double RG1_part = RG1act / q_act_tot;
        double RG2_part = RG2act / q_act_tot;
        double RD1_part_N = 0.0;
        double RD2_part_N = 0.0;
        double RG1_part_N = 0.0;
        double RG2_part_N = 0.0;
        if (q_act_tot_N != 0.0) {
            RD1_part_N = RD1act_N / q_act_tot_N;
            RD2_part_N = RD2act_N / q_act_tot_N;
            RG1_part_N = RG1act_N / q_act_tot_N;
            RG2_part_N = RG2act_N / q_act_tot_N;
        }
        double N_conc_tot = q_act_tot_N / q_act_tot;
        double flow_veloc = this.calcFlowVelocity(q_act_tot, width, slope, rough, 86400);
        double Rk = flow_veloc / length * this.flowRouteTA.getValue() * 3600.0;
        double q_act_out = Rk > 0.0 ? q_act_tot * Math.exp(-1.0 / Rk) : 0.0;
        double q_act_out_N = q_act_out * N_conc_tot;
        if (this.deepsink.getValue() == 1.0) {
            Larea = Math.pow(this.rh, 2.0) * length;
            deepsinkW = Larea * this.Ksink.getValue() * 10.0;
            deepsinkN = deepsinkW * N_conc_tot;
            deepsinkW = Math.min(deepsinkW, q_act_out);
            deepsinkN = Math.min(deepsinkN, q_act_out_N);
            deepsinkW = Math.max(deepsinkW, 0.0);
            deepsinkN = Math.max(deepsinkN, 0.0);
        } else {
            deepsinkW = 0.0;
            deepsinkN = 0.0;
        }
        this.DeepsinkW.setValue(deepsinkW);
        this.DeepsinkN.setValue(deepsinkN);
        double RD1outdeep = deepsinkW * RD1_part;
        double RD2outdeep = deepsinkW * RD2_part;
        double RG1outdeep = deepsinkW * RG1_part;
        double RG2outdeep = deepsinkW * RG2_part;
        double RD1out_Ndeep = deepsinkN * RD1_part_N;
        double RD2out_Ndeep = deepsinkN * RD2_part_N;
        double RG1out_Ndeep = deepsinkN * RG1_part_N;
        double RG2out_Ndeep = deepsinkN * RG2_part_N;
        double RD1out = q_act_out * RD1_part - RD1outdeep;
        double RD2out = q_act_out * RD2_part - RD2outdeep;
        double RG1out = q_act_out * RG1_part - RG1outdeep;
        double RG2out = q_act_out * RG2_part - RG2outdeep;
        double RD1out_N = q_act_out_N * RD1_part_N - RD1out_Ndeep;
        double RD2out_N = q_act_out_N * RD2_part_N - RD2out_Ndeep;
        double RG1out_N = q_act_out_N * RG1_part_N - RG1out_Ndeep;
        double RG2out_N = q_act_out_N * RG2_part_N - RG2out_Ndeep;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        RD1DestIn_N += RD1out_N;
        RD2DestIn_N += RD2out_N;
        RG1DestIn_N += RG1out_N;
        RG2DestIn_N += RG2out_N;
        RD1act = RD1act - RD1out - RD1outdeep;
        if (RD1act < 0.0) {
            RD1act = 0.0;
        }
        if ((RD2act = RD2act - RD2out - RD2outdeep) < 0.0) {
            RD2act = 0.0;
        }
        if ((RG1act = RG1act - RG1out - RG1outdeep) < 0.0) {
            RG1act = 0.0;
        }
        if ((RG2act = RG2act - RG2out - RG1outdeep) < 0.0) {
            RG2act = 0.0;
        }
        if ((RD1act_N = RD1act_N - RD1out_N - RD1out_Ndeep) < 0.0) {
            RD1act_N = 0.0;
        }
        if ((RD2act_N = RD2act_N - RD2out_N - RD2out_Ndeep) < 0.0) {
            RD2act_N = 0.0;
        }
        if ((RG1act_N = RG1act_N - RG1out_N - RG1out_Ndeep) < 0.0) {
            RG1act_N = 0.0;
        }
        if ((RG2act_N = RG2act_N - RG2out_N - RG2out_Ndeep) < 0.0) {
            RG2act_N = 0.0;
        }
        double channelStorage = RD1act + RD2act + RG1act + RG2act;
        double channelStorage_N = RD1act_N + RD2act_N + RG1act_N + RG2act_N;
        double cumOutflow = RD1out + RD2out + RG1out + RG2out;
        double cumOutflow_N = RD1out_N + RD2out_N + RG1out_N + RG2out_N;
        this.simRunoff.setValue(cumOutflow);
        this.SimRunoff_N.setValue(cumOutflow_N);
        this.channelStorage.setValue(channelStorage);
        this.ChannelStorage_N.setValue(channelStorage_N);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.SurfaceN_in.setValue(0.0);
        this.InterflowN_sum.setValue(0.0);
        this.N_RG1_in.setValue(0.0);
        this.N_RG2_in.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.ActRD1_N.setValue(RD1act_N);
        this.ActRD2_N.setValue(RD2act_N);
        this.ActRG1_N.setValue(RG1act_N);
        this.ActRG2_N.setValue(RG2act_N);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.SurfaceNabs.setValue(RD1out_N);
        this.InterflowNabs.setValue(RD2out_N);
        this.N_RG1_out.setValue(RG1out_N);
        this.N_RG2_out.setValue(RG2out_N);
        if (entity.getObject("to_reach") != null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
            DestReach.setDouble("SurfaceN_in", RD1DestIn_N);
            DestReach.setDouble("InterflowN_sum", RD2DestIn_N);
            DestReach.setDouble("N_RG1_in", RG1DestIn_N);
            DestReach.setDouble("N_RG2_in", RG2DestIn_N);
        } else {
            this.catchmentRD1.setValue(RD1out);
            this.catchmentRD2.setValue(RD2out);
            this.catchmentRG1.setValue(RG1out);
            this.catchmentRG2.setValue(RG2out);
            this.catchmentSimRunoff.setValue(cumOutflow);
            this.catchmentNRD1.setValue(RD1out_N);
            this.catchmentNRD2.setValue(RD2out_N);
            this.catchmentNRG1.setValue(RG1out_N);
            this.catchmentNRG2.setValue(RG2out_N);
            this.catchmentSimRunoffN.setValue(cumOutflow_N);
            this.catchmentSimNconc.setValue(cumOutflow_N * 1000000.0 / cumOutflow);
        }
    }

    public void cleanup() {
    }

    public double calcFlowVelocity(double q, double width, double slope, double rough, int secondsOfTimeStep) {
        double afv = 1.0;
        double veloc = 0.0;
        double q_m = q / (double)(1000 * secondsOfTimeStep);
        this.rh = J2KProcessReachRouting_N.calcHydraulicRadius(afv, q_m, width);
        boolean cont = true;
        while (cont) {
            veloc = rough * Math.pow(this.rh, 0.6666666666666666) * Math.sqrt(slope);
            if (Math.abs(veloc - afv) > 0.001) {
                afv = veloc;
                this.rh = J2KProcessReachRouting_N.calcHydraulicRadius(afv, q_m, width);
                continue;
            }
            cont = false;
            afv = veloc;
        }
        return afv;
    }

    public static double calcHydraulicRadius(double v, double q, double width) {
        double A = q / v;
        double rh = A / (width + 2.0 * (A / width));
        return rh;
    }
}

