/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KPlantGrothTemperatureStress", author="Manfred Fink", description="Calculation of the plant groth temperature factor after SWAT")
public class J2KPlantGrowthTemperatureStress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C dayly mean temperature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C plant groth base temperature")
    public JAMSDouble tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C plant groth optimal temperature")
    public JAMSDouble topti;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant groth temperature stress factor")
    public JAMSDouble tstrs;

    public void init() {
    }

    public void run() {
        double run_tstrs = 0.0;
        double run_tmean = this.tmean.getValue();
        double run_topti = this.topti.getValue();
        double run_tbase = this.tbase.getValue();
        if (run_tmean <= run_tbase) {
            run_tstrs = 1.0;
        } else if (run_tmean > run_tbase && run_tmean <= run_topti) {
            run_tstrs = 1.0 - Math.exp(-0.1054 * Math.pow(run_topti - run_tmean, 2.0) / Math.pow(run_tmean - run_tbase, 2.0));
        } else if (run_tmean > run_topti && run_tmean <= 2.0 * run_topti - run_tbase) {
            run_tstrs = 1.0 - Math.exp(-0.1054 * Math.pow(run_topti - run_tmean, 2.0) / Math.pow(2.0 * run_topti - run_tmean - run_tbase, 2.0));
        } else if (run_tmean > 2.0 * run_topti - run_tbase) {
            run_tstrs = 1.0;
        }
        this.tstrs.setValue(run_tstrs);
    }

    public void cleanup() {
    }
}

