/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KNRouting", author="Peter Krause & Manfred Fink", description="Passes the N output of the entities as N input to the respective reach or unit")
public class J2KNRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public JAMSEntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RD1 N inflow in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RD2 N inflow in kgN")
    public JAMSDouble InterflowN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N inflow in kgN")
    public JAMSDouble N_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N inflow in kgN")
    public JAMSDouble N_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RD1 N outflow in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="RD2 N outflow in kgN")
    public JAMSDouble InterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RG1 N outflow in kgN")
    public JAMSDouble N_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.INIT, description="RG2 N outflow in kgN")
    public JAMSDouble N_RG2_out;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntity toPoly = (JAMSEntity)this.entity.getObject("to_poly");
        JAMSEntity toReach = (JAMSEntity)this.entity.getObject("to_reach");
        double NRD1out = this.SurfaceNabs.getValue();
        double NRD2out = this.InterflowNabs.getValue();
        double NRG1out = this.N_RG1_out.getValue();
        double NRG2out = this.N_RG2_out.getValue();
        if (toPoly != null) {
            double NRD1in = toPoly.getDouble("SurfaceN_in");
            double NRD2in = toPoly.getDouble("InterflowN_in");
            double NRG1in = toPoly.getDouble("N_RG1_in");
            double NRG2in = toPoly.getDouble("N_RG2_in");
            NRD1in += NRD1out;
            NRD2in += NRD2out;
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRD2out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.SurfaceNabs.setValue(0.0);
            this.InterflowNabs.setValue(0.0);
            this.N_RG1_out.setValue(0.0);
            this.N_RG2_out.setValue(0.0);
            this.SurfaceN_in.setValue(0.0);
            this.InterflowN_in.setValue(0.0);
            this.N_RG1_in.setValue(0.0);
            this.N_RG2_in.setValue(0.0);
            toPoly.setDouble("SurfaceN_in", NRD1in);
            toPoly.setDouble("InterflowN_in", NRD2in);
            toPoly.setDouble("N_RG1_in", NRG1in);
            toPoly.setDouble("N_RG2_in", NRG2in);
        } else if (toReach != null) {
            double NRD1in = toReach.getDouble("SurfaceN_in");
            double NRD2in = toReach.getDouble("InterflowN_in");
            double NRG1in = toReach.getDouble("N_RG1_in");
            double NRG2in = toReach.getDouble("N_RG2_in");
            NRD1in += NRD1out;
            NRD2in += NRD2out;
            NRG1in += NRG1out;
            NRG2in += NRG2out;
            NRD1out = 0.0;
            NRD2out = 0.0;
            NRG1out = 0.0;
            NRG2out = 0.0;
            this.SurfaceNabs.setValue(0.0);
            this.InterflowNabs.setValue(0.0);
            this.N_RG1_out.setValue(0.0);
            this.N_RG2_out.setValue(0.0);
            this.SurfaceNabs.setValue(NRD1out);
            toReach.setDouble("SurfaceN_in", NRD1in);
            this.InterflowNabs.setValue(NRD2out);
            toReach.setDouble("InterflowN_in", NRD2in);
            this.N_RG1_out.setValue(NRG1out);
            toReach.setDouble("N_RG1_in", NRG1in);
            this.N_RG2_out.setValue(NRG2out);
            toReach.setDouble("N_RG2_in", NRG2in);
        } else {
            System.out.println("Current entity ID: " + this.entity.getInt("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }
}

