/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KGroundwaterN", author="Manfred Fink", description="Groundwater N module with two different N-Pools")
public class J2KGroundwaterN
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 storage")
    public JAMSDouble actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 storage")
    public JAMSDouble actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG1 N storage in kgN")
    public JAMSDouble NActRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual RG2 N storage in kgN")
    public JAMSDouble NActRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG1 inflow")
    public JAMSDouble inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG2 inflow")
    public JAMSDouble inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG1 outflow")
    public JAMSDouble outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="RG2 outflow")
    public JAMSDouble outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 N inflow in kgN")
    public JAMSDouble N_RG1_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 N inflow in kgN")
    public JAMSDouble N_RG2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG1 N outflow in kgN")
    public JAMSDouble N_RG1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="RG2 N outflow in kgN")
    public JAMSDouble N_RG2_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="N Percolation out of the soil profile in kgN")
    public JAMSDouble PercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU Concentration in mgN/l for RG1")
    public JAMSDouble N_concRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU Concentration in mgN/l for RG2")
    public JAMSDouble N_concRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG1 storage")
    public JAMSDouble maxRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum RG2 storage")
    public JAMSDouble maxRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble gwExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="gwExcess")
    public JAMSDouble NExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="portion of percolation to RG1 in l")
    public JAMSDouble pot_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="portion of percolation to RG2 in l")
    public JAMSDouble pot_RG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG1 0 - 10 to calibrate in -")
    public JAMSDouble N_delay_RG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Relativ size of the groundwaterN damping tank RG2 0 - 10 to calibrate in -")
    public JAMSDouble N_delay_RG2;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double runN_RG1_out = 0.0;
        double runN_RG2_out = 0.0;
        double RG1_out = this.outRG1.getValue();
        double RG2_out = this.outRG2.getValue();
        double ActRG1 = this.actRG1.getValue();
        double ActRG2 = this.actRG2.getValue();
        double MaxRG1 = this.maxRG1.getValue();
        double MaxRG2 = this.maxRG2.getValue();
        double rungwExcess = this.gwExcess.getValue();
        double runN_RG1_in = this.N_RG1_in.getValue();
        double runN_RG2_in = this.N_RG2_in.getValue();
        double runNActRG1 = this.NActRG1.getValue();
        double runNActRG2 = this.NActRG2.getValue();
        double runN_concRG1 = 0.0;
        double runN_concRG2 = 0.0;
        double runpot_RG1 = this.pot_RG1.getValue();
        double runpot_RG2 = this.pot_RG2.getValue();
        double percoN = this.PercoNabs.getValue();
        double RGNretentinon = 1.0;
        double N_Excess = this.NExcess.getValue();
        double partN_Excess = 0.0;
        double partN_RG1 = 0.0;
        double partN_RG2 = 0.0;
        double percwatersum = runpot_RG1 + runpot_RG2 + rungwExcess;
        if (percwatersum > 0.0) {
            partN_RG1 = runpot_RG1 / percwatersum * percoN;
            partN_RG2 = runpot_RG2 / percwatersum * percoN;
            partN_Excess = rungwExcess / percwatersum * percoN;
        }
        double watersum_RG1 = ActRG1 + RG1_out + MaxRG1 * this.N_delay_RG1.getValue();
        double watersum_RG2 = ActRG2 + RG2_out + MaxRG2 * this.N_delay_RG2.getValue();
        N_Excess += partN_Excess;
        runNActRG1 = runNActRG1 + runN_RG1_in + partN_RG1;
        runNActRG2 = runNActRG2 + runN_RG2_in + partN_RG2;
        runN_concRG1 = watersum_RG1 > 0.0 ? runNActRG1 * 1000000.0 / watersum_RG1 : 0.0;
        runN_concRG2 = watersum_RG2 > 0.0 ? runNActRG2 * 1000000.0 / watersum_RG2 : 0.0;
        runN_RG1_out = RG1_out * runN_concRG1 / 1000000.0;
        runN_RG2_out = RG2_out * runN_concRG2 / 1000000.0;
        if (runN_RG1_out > runNActRG1) {
            runN_RG1_out = runNActRG1;
        }
        if (runN_RG2_out > runNActRG2) {
            runN_RG2_out = runNActRG2;
        }
        runNActRG1 -= runN_RG1_out;
        runNActRG2 -= runN_RG2_out;
        this.N_RG1_in.setValue(0.0);
        this.N_RG2_in.setValue(0.0);
        this.N_RG1_out.setValue(runN_RG1_out);
        this.N_RG2_out.setValue(runN_RG2_out);
        this.NActRG1.setValue(runNActRG1);
        this.NActRG2.setValue(runNActRG2);
        this.N_concRG1.setValue(runN_concRG1);
        this.N_concRG2.setValue(runN_concRG2);
        this.NExcess.setValue(N_Excess);
    }

    public void cleanup() {
    }
}

