/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer.gradient;

import java.util.Random;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class ABCGradientDescent
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of samples to be taken")
    public JAMSInteger sampleCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="efficiency methods")
    public JAMSString effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="efficiency values")
    public JAMSDouble[] effValues;
    JAMSDouble[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator;
    GenericDataWriter writer;
    double alpha = 1.0;
    double diff = 1.0;
    double alpha_min = 1.0E-10;
    double diff_min = 1.0E-7;
    double approxError = 0.01;

    public void init() {
        String key;
        StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
        this.parameters = new JAMSDouble[tok.countTokens()];
        this.parameterNames = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.parameterNames[i] = key = tok.nextToken();
            this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
            ++i;
        }
        tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int n = tok.countTokens();
        this.lowBound = new double[n];
        this.upBound = new double[n];
        if (n != i) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
        }
        i = 0;
        while (tok.hasMoreTokens()) {
            key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
            this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
            }
            ++i;
        }
        i = 0;
        tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
        String[] effNames = new String[tok.countTokens()];
        i = 0;
        while (tok.hasMoreTokens()) {
            effNames[i] = key = tok.nextToken();
            ++i;
        }
    }

    private boolean hasNext() {
        return this.alpha > this.alpha_min && this.diff > this.diff_min;
    }

    private double[] abcRandomSampler() {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0.0;
        double[] sample = new double[paras];
        for (int i = 0; i < paras; ++i) {
            double d;
            if (this.parameterNames[i].equals("abcModel.a") || this.parameterNames[i].equals("abcModel.b")) {
                if (criticalPara) {
                    d = this.generator.nextDouble();
                    double upperBound = 1.0 - criticalParaValue;
                    sample[i] = this.lowBound[i] + d * (upperBound - this.lowBound[i]);
                } else {
                    d = this.generator.nextDouble();
                    sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
                    criticalPara = true;
                    criticalParaValue = sample[i];
                }
            } else {
                d = this.generator.nextDouble();
                sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
            }
            this.getModel().getRuntime().sendInfoMsg("Para: " + this.parameterNames[i] + " = " + sample[i]);
        }
        return sample;
    }

    private void resetValues() {
        this.generator = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.parameters.length; ++i) {
            double d = this.generator.nextDouble();
            this.parameters[i].setValue(this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]));
        }
        this.currentCount = 0;
    }

    private void singleRun() {
        JAMSComponent comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private boolean IsSampleValid(JAMSDouble[] sample) {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0.0;
        for (int i = 0; i < paras; ++i) {
            if (this.parameterNames[i].equals("abcModel.a") || this.parameterNames[i].equals("abcModel.b")) {
                if (criticalPara) {
                    double upperBound = 1.0 - criticalParaValue;
                    if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > upperBound)) continue;
                    return false;
                }
                if (sample[i].getValue() < this.lowBound[i] || sample[i].getValue() > this.upBound[i]) {
                    return false;
                }
                criticalPara = true;
                criticalParaValue = sample[i].getValue();
                continue;
            }
            if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.resetValues();
        for (int e = 0; e < this.effValues.length; ++e) {
            double[] x = this.abcRandomSampler();
            double[] grad = new double[this.parameters.length];
            this.alpha = 1.0;
            this.diff = 1.0;
            while (this.hasNext()) {
                int i;
                int i2;
                for (i2 = 0; i2 < this.parameters.length; ++i2) {
                    this.parameters[i2].setValue(x[i2]);
                }
                this.singleRun();
                double y1 = this.effValues[e].getValue();
                for (i2 = 0; i2 < this.parameters.length; ++i2) {
                    for (int j = 0; j < this.parameters.length; ++j) {
                        if (j == i2) {
                            this.parameters[j].setValue(x[j] + this.approxError);
                            continue;
                        }
                        this.parameters[j].setValue(x[j]);
                    }
                    if (!this.IsSampleValid(this.parameters)) {
                        grad[i2] = 0.0;
                        continue;
                    }
                    this.singleRun();
                    double y2 = this.effValues[e].getValue();
                    grad[i2] = (y2 - y1) / this.approxError;
                }
                this.alpha *= 4.0;
                do {
                    for (i2 = 0; i2 < this.parameters.length; ++i2) {
                        this.parameters[i2].setValue(x[i2] + this.alpha * grad[i2]);
                    }
                    if (this.IsSampleValid(this.parameters)) {
                        this.singleRun();
                        if (this.effValues[e].getValue() > y1) break;
                    }
                    this.alpha /= 2.0;
                } while (!(this.alpha < this.alpha_min));
                String info = "Gradient:\t";
                for (i = 0; i < this.parameters.length; ++i) {
                    int n = i;
                    x[n] = x[n] + this.alpha * grad[i];
                    info = info + grad[i] + "\t";
                }
                this.getModel().getRuntime().println(info);
                info = "Stelle:\t\t";
                for (i = 0; i < this.parameters.length; ++i) {
                    info = info + this.parameters[i].getValue() + "\t";
                }
                this.getModel().getRuntime().println(info);
                this.getModel().getRuntime().println("Funktionswert:\t" + y1 + "\t Alpha: " + this.alpha);
            }
            this.getModel().getRuntime().println("***************************************************************");
            this.getModel().getRuntime().println("***************************************************************");
            this.getModel().getRuntime().println("Optimierung f\u00c3\u00bcr Ma\u00c3\u0178 Nummer: " + e + " abgeschlossen!!");
            this.getModel().getRuntime().println("***************************************************************");
            this.getModel().getRuntime().println("***************************************************************");
        }
    }
}

