/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.OrderedAxisAuthorityFactory;
import org.geotools.referencing.factory.epsg.DefaultFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;

public class LongitudeFirstFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory {
    public static final String SYSTEM_DEFAULT_KEY = "org.geotools.referencing.forceXY";
    private ServiceRegistry registry;
    private int counter;

    public LongitudeFirstFactory() {
        this((Hints)null);
    }

    public LongitudeFirstFactory(Hints hints) {
        super(hints, 90 + LongitudeFirstFactory.relativePriority());
        this.put(null, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        this.put(hints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(hints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints source, Hints.Key key) {
        Object value;
        if (source != null) {
            value = source.get(key);
            if (value == null) {
                value = Boolean.TRUE;
            }
        } else {
            value = Boolean.TRUE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority() {
        try {
            if (Boolean.getBoolean(SYSTEM_DEFAULT_KEY)) {
                return 10;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -10;
    }

    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        DefaultFactory factory = null;
        if (this.registry != null) {
            factory = (DefaultFactory)this.registry.getServiceProviderByClass(DefaultFactory.class);
        }
        if (factory == null) {
            try {
                factory = (DefaultFactory)FactoryFinder.getCRSAuthorityFactory("EPSG", new Hints(Hints.CRS_AUTHORITY_FACTORY, DefaultFactory.class));
            }
            catch (FactoryRegistryException exception) {
                throw new FactoryException(exception);
            }
        }
        return new OrderedAxisAuthorityFactory(factory, new Hints(this.hints), null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.registry == null) {
            this.registry = registry;
        } else if (this.registry != registry) {
            throw new IllegalStateException();
        }
        ++this.counter;
    }

    public void onDeregistration(ServiceRegistry registry, Class category) {
        if (this.registry != registry) {
            throw new IllegalStateException();
        }
        if (--this.counter == 0) {
            this.registry = null;
        }
        super.onDeregistration(registry, category);
    }
}

