/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;

public class FactoryUsingOracleSQL
extends FactoryUsingAnsiSQL {
    private final Pattern pattern = Pattern.compile("\\sAS\\s");

    public FactoryUsingOracleSQL(Hints hints, Connection connection) {
        super(hints, connection);
    }

    public FactoryUsingOracleSQL(Hints hints, Connection connection, String epsgSchema) {
        super(hints, connection);
        this.adaptTableNames(epsgSchema);
    }

    protected String adaptSQL(String statement) {
        return this.pattern.matcher(super.adaptSQL(statement)).replaceAll(" ");
    }

    private void adaptTableNames(String epsgSchema) {
        if (epsgSchema != null && (epsgSchema = epsgSchema.trim()).length() != 0) {
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String tableName = (String)entry.getValue();
                if (!tableName.startsWith("epsg_")) continue;
                entry.setValue(epsgSchema + '.' + tableName);
            }
        }
    }
}

