/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.factory.FactoryRegistry;
import org.geotools.io.TableWriter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;

final class FactoryPrinter
implements Comparator {
    public int compare(Object object1, Object object2) {
        Class factory1 = (Class)object1;
        Class factory2 = (Class)object2;
        return Utilities.getShortName(factory1).compareToIgnoreCase(Utilities.getShortName(factory2));
    }

    public void list(FactoryRegistry registry, Writer out, Locale locale) throws IOException {
        ArrayList categories = new ArrayList();
        Iterator<Class<?>> it = registry.getCategories();
        while (it.hasNext()) {
            categories.add(it.next());
        }
        Collections.sort(categories, this);
        Vocabulary resources = Vocabulary.getResources(locale);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(203));
        table.nextColumn();
        table.write(resources.getString(223));
        table.nextColumn();
        table.write(resources.getString(222));
        table.nextColumn();
        table.write(resources.getString(75));
        table.nextLine();
        table.nextLine('\u2550');
        StringBuffer vendors = new StringBuffer();
        StringBuffer implementations = new StringBuffer();
        Iterator it2 = categories.iterator();
        while (it2.hasNext()) {
            Class category = (Class)it2.next();
            table.write(Utilities.getShortName(category));
            table.nextColumn();
            Iterator providers = registry.getServiceProviders(category);
            while (providers.hasNext()) {
                if (implementations.length() != 0) {
                    table.write(10);
                    vendors.append('\n');
                    implementations.append('\n');
                }
                Factory provider = (Factory)providers.next();
                Citation vendor = provider.getVendor();
                vendors.append(vendor.getTitle().toString(locale));
                implementations.append(Utilities.getShortClassName(provider));
                if (!(provider instanceof AuthorityFactory)) continue;
                Citation authority = ((AuthorityFactory)provider).getAuthority();
                Iterator identifiers = authority.getIdentifiers().iterator();
                String identifier = identifiers.hasNext() ? identifiers.next().toString() : authority.getTitle().toString(locale);
                table.write(identifier);
            }
            table.nextColumn();
            table.write(vendors.toString());
            vendors.setLength(0);
            table.nextColumn();
            table.write(implementations.toString());
            implementations.setLength(0);
            table.writeHorizontalSeparator();
        }
        table.flush();
    }
}

