/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import org.unijena.predictionnet.kernels.Kernel;

public class SimpleExponential
extends Kernel {
    public SimpleExponential(int inputDim) {
        this.inputDim = inputDim;
        this.KernelParameterCount = 1;
        this.parameterCount = 1;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y);
        if (index1 == index2) {
            return Math.exp(-0.5 * r) + this.theta[0] * this.theta[0];
        }
        return Math.exp(-0.5 * r);
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

