/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.Converter;

public final class MultiplyConverter
extends Converter {
    private final double _factor;

    public MultiplyConverter(double d) {
        this._factor = d;
    }

    public Converter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }

    public double convert(double d) {
        return this._factor * d;
    }

    public double derivative(double d) {
        return this._factor;
    }

    public boolean isLinear() {
        return true;
    }

    public Converter concatenate(Converter converter) {
        if (converter instanceof MultiplyConverter) {
            double d = this._factor * ((MultiplyConverter)converter)._factor;
            return new MultiplyConverter(d);
        }
        return super.concatenate(converter);
    }
}

