/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jams.j2k.s_n.crop.J2KSNCrop;
import org.jams.j2k.s_n.crop.J2KSNFertilizer;
import org.jams.j2k.s_n.crop.J2KSNLMArable;
import org.jams.j2k.s_n.crop.J2KSNTillage;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardManagementParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Crop parameter file name")
    public JAMSString cropFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Fertilization parameter file name")
    public JAMSString fertFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Tillage parameter file name")
    public JAMSString tillFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Management parameter file name")
    public JAMSString managementFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Rotation parameter file name")
    public JAMSString rotationFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU rotation mapping file name")
    public JAMSString hruRotationFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name of HRU ID")
    public JAMSString aNameHRUID;

    private HashMap<Integer, J2KSNFertilizer> readFertPara(String fileName) {
        String[] vals = new String[11];
        HashMap<Integer, J2KSNFertilizer> map = new HashMap<Integer, J2KSNFertilizer>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < 11; ++i) {
                    vals[i] = tokenizer.nextToken();
                }
                map.put(Integer.parseInt(vals[0]), new J2KSNFertilizer(vals));
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return map;
    }

    private HashMap<Integer, J2KSNTillage> readTillPara(String fileName) {
        String[] vals = new String[5];
        HashMap<Integer, J2KSNTillage> map = new HashMap<Integer, J2KSNTillage>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < 5; ++i) {
                    vals[i] = tokenizer.nextToken();
                }
                map.put(Integer.parseInt(vals[0]), new J2KSNTillage(vals));
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return map;
    }

    private HashMap<Integer, ArrayList<J2KSNLMArable>> readManagementPara(String fileName, HashMap<Integer, J2KSNTillage> tills, HashMap<Integer, J2KSNFertilizer> ferts) {
        String[] vals = new String[8];
        int oldCID = -1;
        int cid = -1;
        ArrayList<J2KSNLMArable> managements = null;
        HashMap<Integer, ArrayList<J2KSNLMArable>> map = new HashMap<Integer, ArrayList<J2KSNLMArable>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < 8; ++i) {
                    vals[i] = tokenizer.nextToken();
                }
                cid = Integer.parseInt(vals[0]);
                if (cid != oldCID) {
                    map.put(oldCID, managements);
                    managements = new ArrayList<J2KSNLMArable>();
                    oldCID = cid;
                }
                managements.add(new J2KSNLMArable(vals, tills, ferts));
                s = reader.readLine();
            }
            map.put(cid, managements);
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return map;
    }

    private HashMap<Integer, J2KSNCrop> readCrops(String fileName, HashMap<Integer, ArrayList<J2KSNLMArable>> management) {
        String[] vals = new String[50];
        HashMap<Integer, J2KSNCrop> map = new HashMap<Integer, J2KSNCrop>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < 50; ++i) {
                    vals[i] = tokenizer.nextToken();
                }
                Integer id = Integer.parseInt(vals[0]);
                J2KSNCrop crop = new J2KSNCrop(vals, management.get(id));
                map.put(crop.cid, crop);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return map;
    }

    private HashMap<Integer, ArrayList<J2KSNCrop>> readRotations(String fileName, HashMap<Integer, J2KSNCrop> crops) {
        HashMap<Integer, ArrayList<J2KSNCrop>> map = new HashMap<Integer, ArrayList<J2KSNCrop>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                ArrayList<J2KSNCrop> cropList = new ArrayList<J2KSNCrop>();
                Integer rid = Integer.parseInt(tokenizer.nextToken());
                while (tokenizer.hasMoreElements()) {
                    Integer cid = Integer.parseInt(tokenizer.nextToken());
                    cropList.add(crops.get(cid));
                }
                map.put(rid, cropList);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
        return map;
    }

    private void linkCrops(String fileName, HashMap<Integer, ArrayList<J2KSNCrop>> rotations) {
        HashMap<Double, JAMSEntity> hruMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity hru : this.hrus.getEntities()) {
            try {
                hruMap.put(hru.getDouble(this.aNameHRUID.getValue()), hru);
            }
            catch (JAMSEntity.NoSuchAttributeException nsae) {}
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                JAMSEntity hru;
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                Double hid = Double.parseDouble(tokenizer.nextToken());
                if (hid == 600.0) {
                    double dummy = 0.0;
                }
                Integer rid = Integer.parseInt(tokenizer.nextToken());
                Double redu_fac = Double.parseDouble(tokenizer.nextToken());
                ArrayList<J2KSNCrop> rotation = rotations.get(rid);
                hru = (JAMSEntity)hruMap.get(hid);
                hru.setDouble("ReductionFactor", redu_fac.doubleValue());
                hru.setObject("landuseRotation", rotation);
                hru.setInt("rotPos", 0);
                hru.setInt("managementPos", 0);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Exception)ioe);
        }
    }

    public void run() {
        HashMap<Integer, J2KSNFertilizer> ferts = this.readFertPara(this.dirName.getValue() + "/" + this.fertFileName.getValue());
        HashMap<Integer, J2KSNTillage> tills = this.readTillPara(this.dirName.getValue() + "/" + this.tillFileName.getValue());
        HashMap<Integer, ArrayList<J2KSNLMArable>> managements = this.readManagementPara(this.dirName.getValue() + "/" + this.managementFileName.getValue(), tills, ferts);
        HashMap<Integer, J2KSNCrop> crops = this.readCrops(this.dirName.getValue() + "/" + this.cropFileName.getValue(), managements);
        HashMap<Integer, ArrayList<J2KSNCrop>> rotations = this.readRotations(this.dirName.getValue() + "/" + this.rotationFileName.getValue(), crops);
        this.linkCrops(this.dirName.getValue() + "/" + this.hruRotationFileName.getValue(), rotations);
    }

    public static void main(String[] x) {
        StandardManagementParaReader r = new StandardManagementParaReader();
        r.run();
    }
}

