/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n.crop;

import java.io.IOException;
import java.util.ArrayList;
import org.jams.j2k.s_n.crop.J2KSNCrop;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="j2kCropGrowth", author="Ulrike Bende-Michl", description="Module for calculation of crop growth according to the algorithms of SWAT")
public class j2kpotCropGrowth_uli
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object")
    public JAMSEntity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current hru object id")
    public JAMSDouble idValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN)
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area")
    public JAMSDouble Area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU daily mean temperature [\u00c2\u00b0C]")
    public JAMSDouble Tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily solar radiation [MJ/m\u00c2\u00b2]")
    public JAMSDouble SolRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass sum produced for a given day [kg/ha] drymass")
    public JAMSDouble BioAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass sum produced for a day before [kg/ha] drymass")
    public JAMSDouble BioOld;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual canopy Height [m]")
    public JAMSDouble CanHeightAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual rooting depth [mm]")
    public JAMSDouble ZRootD;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Fraction of nitrogen in the plant optimal biomass at the current growth's stage")
    public JAMSDouble FNPlant;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual nitrogen stored in the plants biomass for a given day")
    public JAMSDouble BioNact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Potential Crop Yield [kg/ha] for the actual day")
    public JAMSDouble Yield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass above ground on the day of harvest [kg/ha]")
    public JAMSDouble BioagAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="added residue pool after harvesting [kg N ha]")
    public JAMSDouble Residue_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU actual Transpiration [mm]")
    public JAMSDouble aTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU potential Transpiration [mm]")
    public JAMSDouble pTP;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Light Extinct Coefficient [-0.65]")
    public JAMSDouble LExCoef;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in plants biomass [kg N/ha]")
    public JAMSDouble BioNoptAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual plants N demand [kg N/ha]")
    public JAMSDouble PlantNDemAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max LAI [-]")
    public JAMSDouble frLAImxAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max LAI [-]")
    public JAMSDouble frLAImx_xi;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Daily fraction of max root development [-]")
    public JAMSDouble frRootAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="root development of the day before [cm]")
    public JAMSDouble ZRootOld;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual yield [kg/ha]")
    public JAMSDouble BioYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in yield [absolut]")
    public JAMSDouble NYield;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N content in yield [kg N/ha]")
    public JAMSDouble NYield_ha;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Actual N in Biomass (after Stress)")
    public JAMSDouble BioNAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual harvest index [0-1]")
    public JAMSDouble HarvIndex;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual potential heat units sum [-]")
    public JAMSDouble FPHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="delta potential heat units sum [-]")
    public JAMSDouble PHUdelta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="delta potential heat units sum [-]")
    public JAMSDouble PHUdeltaold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="delta LAI [-]")
    public JAMSDouble LAIdelta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual LAI")
    public JAMSDouble LAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="LAI of the day before ")
    public JAMSDouble LAIold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrate uptake by plants in kgN/ha")
    public JAMSDouble actN_up;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="flag plant existing yes or no ")
    public JAMSBoolean plantExisting = new JAMSBoolean();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual potential heat units sum [-]")
    public JAMSDouble PHUact;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants base growth temperature [\u00c2\u00b0C]")
    public JAMSDouble tbase;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants optimum growth temperature [\u00c2\u00b0C]")
    public JAMSDouble topt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants optimum growth temperature [\u00c2\u00b0C]")
    public JAMSDouble Test;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Plants daily biomass increase [kg/ha]")
    public JAMSDouble BioOpt_delta;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Reset plant state variables?")
    public JAMSBoolean plantStateReset = new JAMSBoolean();
    private double area_ha;
    private double sc1_LAI;
    private double sc2_LAI;
    private double sc3_Nbio;
    private double sc4_Nbio;
    private double frLAImx_act;
    private double lai_act;
    private double lai_old;
    private double fnplant_act;
    private double residue_pool;
    private double hc_act;
    private double idc;
    private double phu_50;
    private double phu;
    private double phu_delta;
    private double fphu_act;
    private double phu_daily;
    private double phu_deltaold;
    private double phu_Xi;
    private double aTransP;
    private double pTransP;
    private double int_lai;
    private double mlai1;
    private double mlai;
    private double mlai2;
    private double frgrw1;
    private double frgrw2;
    private double frLAImx;
    private double frLAImx_actnew;
    private double frLAImx_Xi;
    private double LAI_actnew;
    private double solrad;
    private double rue;
    private double leco;
    private double chtmx;
    private double rdmx;
    private double frroot_act;
    private double zrootd_act;
    private double zrootd_old;
    private double zrootd;
    private double bn1;
    private double bn2;
    private double bn3;
    private double betaN;
    private double hvsti;
    private double cnyld;
    private double Ndemand_act;
    private double bioNopt_act;
    private double bioN_act;
    private double bio_act;
    private double bio_opt;
    private double bio_old;
    private double bioopt_ha;
    private double hi_act;
    private double bioag_act;
    private double yldN;
    private double yldN_ha;
    private double yield;
    private double tmean;
    private double Tbase;
    private double Topt;
    private double julday;
    public double famount;
    public boolean plant;
    public int harvest;
    public double fracharvest;
    private double LAI_delta;
    private double frLAImx_delta;
    private double enty_id;
    private double test;
    private double soil_no3;
    private double bioNopt_accumu;
    private double Ndemand_accumu;
    private double actN_uprun;
    private double bio_opt_delta;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.test = this.Test.getValue();
        this.tmean = this.Tmean.getValue();
        this.fphu_act = this.FPHUact.getValue();
        this.phu_daily = this.PHUact.getValue();
        this.phu_delta = this.PHUdelta.getValue();
        this.phu_deltaold = this.PHUdeltaold.getValue();
        this.area_ha = this.Area.getValue() / 10000.0;
        this.solrad = this.SolRad.getValue();
        this.leco = this.LExCoef.getValue();
        this.frLAImx_act = this.frLAImxAct.getValue();
        this.frLAImx_Xi = this.frLAImx_xi.getValue();
        this.lai_act = this.LAI.getValue();
        this.LAI_delta = this.LAIdelta.getValue();
        this.lai_old = this.LAIold.getValue();
        this.hc_act = this.CanHeightAct.getValue();
        this.frroot_act = this.frRootAct.getValue();
        this.zrootd_act = this.ZRootD.getValue();
        this.zrootd_old = this.ZRootOld.getValue();
        this.fnplant_act = this.FNPlant.getValue();
        this.bioNopt_act = this.BioNoptAct.getValue();
        this.Ndemand_act = this.PlantNDemAct.getValue();
        this.bioN_act = this.BioNAct.getValue();
        this.hi_act = this.HarvIndex.getValue();
        this.bioag_act = this.BioagAct.getValue();
        this.bio_opt = this.BioAct.getValue();
        this.actN_uprun = this.actN_up.getValue();
        this.bio_opt_delta = this.BioOpt_delta.getValue();
        this.yield = this.BioYield.getValue();
        this.yldN = this.NYield.getValue();
        this.yldN_ha = this.NYield_ha.getValue();
        this.residue_pool = this.Residue_pool.getValue();
        ArrayList rotation = (ArrayList)this.entity.getObject("landuseRotation");
        int rotPos = this.entity.getInt("rotPos");
        J2KSNCrop crop = (J2KSNCrop)rotation.get(rotPos);
        this.phu = crop.phu;
        this.idc = crop.idc;
        this.rue = crop.rue;
        this.hvsti = crop.hvsti;
        this.frgrw1 = crop.frgrw1;
        this.frgrw2 = crop.frgrw2;
        this.mlai = crop.mlai;
        this.mlai1 = crop.laimx1;
        this.mlai2 = crop.laimx2;
        this.chtmx = crop.chtmx;
        this.rdmx = crop.rdmx;
        this.Topt = crop.topt;
        this.Tbase = crop.tbase;
        this.cnyld = crop.cnyld;
        this.bn1 = crop.bn1;
        this.bn2 = crop.bn2;
        this.bn3 = crop.bn3;
        if (this.plantExisting.getValue()) {
            this.calc_phu();
            this.calc_lai();
            this.bio_opt = this.calc_biomass();
            this.hc_act = this.calc_canopy();
            this.calc_root();
            this.calc_maturity();
            this.calc_nuptake();
            this.calc_cropyield();
            this.calc_cropyield_ha();
            this.calc_residues();
            this.PHUdelta.setValue(this.phu_delta);
            this.PHUact.setValue(this.phu_daily);
            this.frLAImxAct.setValue(this.frLAImx_act);
            this.LAIdelta.setValue(this.LAI_delta);
            this.LAI.setValue(this.lai_act);
            this.LAIold.setValue(this.lai_old);
            this.CanHeightAct.setValue(this.hc_act);
            this.frRootAct.setValue(this.frroot_act);
            this.ZRootD.setValue(this.zrootd_act);
            this.ZRootOld.setValue(this.zrootd_old);
            this.FNPlant.setValue(this.fnplant_act);
            this.BioNoptAct.setValue(this.bioNopt_act);
            this.BioAct.setValue(this.bio_opt);
            this.BioOld.setValue(this.bio_old);
            this.PlantNDemAct.setValue(this.Ndemand_act);
            this.BioOpt_delta.setValue(this.bio_opt_delta);
            this.HarvIndex.setValue(this.hi_act);
            this.BioagAct.setValue(this.bioag_act);
            this.BioYield.setValue(this.yield);
            this.NYield.setValue(this.yldN);
            this.NYield_ha.setValue(this.yldN_ha);
            this.FPHUact.setValue(this.fphu_act);
            this.BioNAct.setValue(this.bioN_act);
            this.frLAImx_xi.setValue(this.frLAImx_Xi);
            this.Residue_pool.setValue(this.residue_pool);
            this.plantStateReset.setValue(true);
            this.Test.setValue(this.test);
        } else if (this.plantStateReset.getValue()) {
            this.PHUdelta.setValue(0.0);
            this.PHUdeltaold.setValue(0.0);
            this.LAIdelta.setValue(0.0);
            this.frLAImxAct.setValue(0.0);
            this.frLAImx_xi.setValue(0.0);
            this.LAI.setValue(0.0);
            this.LAIold.setValue(0.0);
            this.CanHeightAct.setValue(0.0);
            this.frRootAct.setValue(0.0);
            this.ZRootD.setValue(0.0);
            this.ZRootOld.setValue(0.0);
            this.FNPlant.setValue(0.0);
            this.BioNoptAct.setValue(0.0);
            this.BioAct.setValue(0.0);
            this.PlantNDemAct.setValue(0.0);
            this.HarvIndex.setValue(0.0);
            this.BioagAct.setValue(0.0);
            this.BioOld.setValue(0.0);
            this.BioYield.setValue(0.0);
            this.BioOpt_delta.setValue(0.0);
            this.NYield.setValue(0.0);
            this.NYield_ha.setValue(0.0);
            this.FPHUact.setValue(0.0);
            this.BioNAct.setValue(0.0);
            this.PHUact.setValue(0.0);
            this.PlantNDemAct.setValue(0.0);
            this.plantStateReset.setValue(false);
            this.PlantNDemAct.setValue(0.0);
            this.Residue_pool.setValue(0.0);
            this.Test.setValue(0.0);
        }
    }

    private boolean calc_phu() throws JAMSEntity.NoSuchAttributeException {
        if (this.tmean > this.Tbase) {
            this.phu_daily += this.tmean - this.Tbase;
            this.fphu_act = this.phu_daily / this.phu;
        }
        return true;
    }

    private boolean calc_lai() throws JAMSEntity.NoSuchAttributeException {
        double sc1_lai1 = Math.log(this.frgrw1 / this.mlai1 - this.frgrw1);
        double sc2_lai2 = Math.log(this.frgrw2 / this.mlai2 - this.frgrw2);
        double sc_frpuh = this.frgrw2 - this.frgrw1;
        this.sc2_LAI = (sc1_lai1 - sc2_lai2) / sc_frpuh;
        this.sc1_LAI = sc1_lai1 + this.sc2_LAI * this.frgrw1;
        double sc_minus = this.fphu_act * this.sc2_LAI;
        this.frLAImx_Xi = this.frLAImx_act;
        double x = this.fphu_act + Math.exp(this.sc1_LAI - sc_minus);
        this.frLAImx_act = this.fphu_act / x;
        this.frLAImx_delta = this.frLAImx_act - this.frLAImx_Xi;
        double u1 = this.lai_old - this.mlai;
        double u2 = 5.0 * u1;
        double u3 = this.frLAImx_delta;
        this.LAI_delta = u3 * this.mlai * (1.0 - Math.exp(u2));
        this.lai_act += this.LAI_delta;
        if (this.lai_act == this.mlai) {
            this.lai_act = this.mlai;
        }
        double fphu_sense = 0.99;
        if (this.idc == 7.0 || this.fphu_act > fphu_sense) {
            this.lai_act = 16.0 * this.mlai * Math.pow(1.0 - this.fphu_act, 2.0);
        }
        return true;
    }

    private double calc_biomass() throws JAMSEntity.NoSuchAttributeException {
        double Hphosyn = 0.5 * this.solrad * (1.0 - Math.exp(this.leco * this.lai_act));
        this.bio_opt_delta = this.rue * Hphosyn;
        this.bio_opt = this.bio_opt_delta + this.bio_opt;
        return this.bio_opt;
    }

    private double calc_canopy() throws JAMSEntity.NoSuchAttributeException {
        double hc_delta = this.chtmx * Math.sqrt(this.frLAImx_act);
        this.hc_act = hc_delta + this.hc_act;
        return this.hc_act;
    }

    private boolean calc_root() throws JAMSEntity.NoSuchAttributeException {
        this.frroot_act = 0.4 - 0.2 * this.fphu_act;
        if (this.idc == 3.0 || this.idc == 6.0 || this.idc == 7.0) {
            double zrootd_act = this.rdmx;
        }
        if (this.idc == 1.0 || this.idc == 2.0 || this.idc == 4.0 || this.idc == 5.0 && this.fphu_act <= 0.4) {
            double zrootd = 2.5 * this.fphu_act * this.rdmx;
            this.zrootd_act += zrootd;
        }
        if (this.fphu_act > 0.4) {
            this.zrootd_act = this.rdmx;
        }
        return true;
    }

    private boolean calc_maturity() throws JAMSEntity.NoSuchAttributeException {
        if (this.fphu_act >= 1.0) {
            this.aTransP = 0.0;
            double Nup_act = 0.0;
            double d = 0.0;
        }
        return true;
    }

    private boolean calc_nuptake() throws JAMSEntity.NoSuchAttributeException {
        this.phu_50 = this.phu / 2.0;
        double b1 = this.bn1 - this.bn3;
        double t1 = Math.log(this.phu_50 / (1.0 - (this.bn2 - this.bn3) / (this.bn1 - this.bn3)) - this.phu_50);
        double sc2_Nbio = 30.0;
        double sc1_Nbio = 12.0;
        double y = this.fphu_act / (this.fphu_act + Math.exp(sc1_Nbio - sc2_Nbio * this.fphu_act));
        this.fnplant_act = b1 * (1.0 - y) + this.bn3;
        this.bioNopt_act = this.fnplant_act * this.bio_opt;
        this.bioN_act += this.actN_uprun;
        this.Ndemand_act = this.bioNopt_act - this.bioN_act;
        if (this.betaN == 1.0) {
            double Nup_layer = this.zrootd_act;
        } else if (this.betaN > 1.0) {
            double Nup_layer = this.betaN / this.zrootd_act * 100.0;
        } else if (this.betaN == 0.0) {
            double Nup_layer = 0.1;
            double Nup_depth = this.Ndemand_act / (1.0 - Math.exp(-this.betaN)) * (1.0 - Math.exp(-this.betaN * this.rdmx / this.zrootd_act));
        }
        return true;
    }

    private boolean calc_cropyield() throws JAMSEntity.NoSuchAttributeException {
        double u1 = 100.0 * this.fphu_act;
        this.hi_act = this.hvsti * u1 / (u1 + Math.exp(11.1 - 10.0 * this.fphu_act));
        double bio_ag = (1.0 - this.frroot_act) * this.bio_opt;
        this.bioag_act = bio_ag + this.bioag_act;
        if (this.fphu_act >= 1.0) {
            double bioag_harvest = this.bioag_act;
        }
        if (this.hvsti <= 1.0) {
            this.yield = this.bioag_act * this.hi_act;
        } else if (this.hvsti > 1.0) {
            this.yield = this.bio_opt * (1.0 - 1.0 / (1.0 + this.hi_act));
        }
        this.yldN = this.cnyld * this.yield;
        return true;
    }

    private double calc_cropyield_ha() throws JAMSEntity.NoSuchAttributeException {
        this.yldN_ha = this.yldN * this.area_ha / 10000.0;
        return this.yldN_ha;
    }

    private boolean calc_residues() throws JAMSEntity.NoSuchAttributeException {
        this.residue_pool = this.yield * (1.0 - this.fracharvest);
        return true;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

