/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KSoilTemp", author="Manfred Fink", description="Calculates soil temperature in diffrent depths")
public class J2KSoilTemp
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C daily max. temperature")
    public JAMSDouble atemp_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C dayly min. temperature")
    public JAMSDouble atemp_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C dayly mean. temperature")
    public JAMSDouble atemp_mean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C anual mean temperature")
    public JAMSDouble anatemp_mean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil layer")
    public JAMSDouble layerdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in mm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDouble soil_bulk_density;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Temperature lag coefficient perhaps to calibrate, typcal value 0.8, range  0 - 1")
    public JAMSDouble temp_lag;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSDouble Sat_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSDouble Sat_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum MPS  in l soil water content")
    public JAMSDouble stohru_MPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum LPS  in l soil water content")
    public JAMSDouble stohru_LPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="snowcover in mm water aequivalent")
    public JAMSDouble snowcover;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="soilalbedo")
    public JAMSDouble soilalbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="global radiation in MJ/(m\u00c2\u00b2*d)")
    public JAMSDouble radiation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSDouble Soil_Temp_Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="in \u00c2\u00b0C *  Output soil surface temperature")
    public JAMSDouble Surfacetemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="aboveground biomass in dt/ha")
    public JAMSDouble biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of state variables LAI ")
    public JAMSDoubleArray LAIArray = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    double Soil_Temp;
    double surfacet;
    double radiat;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.radiat = this.radiation.getValue();
        this.Soil_Temp = this.Soil_Temp_Layer.getValue();
        double runSoil_Temp_Layer = this.calc_Soil_Temp_Layer();
        this.Soil_Temp_Layer.setValue(runSoil_Temp_Layer);
    }

    private double calc_Soil_Temp_Layer() throws JAMSEntity.NoSuchAttributeException {
        double depthfactor = this.calc_Soil_Temp_Depth_Factor();
        double surfacetemp = this.calc_Soil_Surface_Temp();
        double temp_lag1 = this.temp_lag.getValue();
        double anavgtemp = this.anatemp_mean.getValue();
        this.Soil_Temp = temp_lag1 * this.Soil_Temp + (1.0 - temp_lag1) * (depthfactor * (anavgtemp - surfacetemp) + surfacetemp);
        return this.Soil_Temp;
    }

    private double calc_water_content() throws JAMSEntity.NoSuchAttributeException {
        double soilwater = 0.0;
        double area_ = this.area.getValue();
        double sto_LPS = this.stohru_LPS.getValue() / area_;
        double sto_MPS = this.stohru_MPS.getValue() / area_;
        double sto_FPS = 0.3 * sto_MPS;
        double act_LPS = sto_LPS * this.Sat_LPS.getValue();
        double act_MPS = sto_MPS * this.Sat_MPS.getValue();
        soilwater = act_LPS + act_MPS + sto_FPS;
        return soilwater;
    }

    private double calc_Soil_Temp_Depth_Factor() throws JAMSEntity.NoSuchAttributeException {
        double dampingdepth = this.calc_Soil_Temp_Dampingdepth();
        double depthfactor = dampingdepth / (dampingdepth + Math.exp(-0.867 - 2.078 * dampingdepth));
        return depthfactor;
    }

    private double calc_Soil_Temp_Dampingdepth() throws JAMSEntity.NoSuchAttributeException {
        double l_depth = this.layerdepth.getValue() * 10.0 / 2.0;
        double t_depth = this.totaldepth.getValue() * 10.0;
        double soil_bulk_dens = this.soil_bulk_density.getValue();
        double soilwater = this.calc_water_content();
        double dd_max = 1000.0 + 2500.0 * soil_bulk_dens / (soil_bulk_dens + 686.0 * Math.exp(-5.63 * soil_bulk_dens));
        double lamda = soilwater / ((0.356 - 0.144 * soil_bulk_dens) * t_depth);
        double dd = dd_max * Math.exp(Math.log(500.0 / dd_max) * ((1.0 - lamda) / (1.0 + lamda)) * ((1.0 - lamda) / (1.0 + lamda)));
        double dampingdepth = l_depth / dd;
        return dampingdepth;
    }

    private double calc_Soil_Surface_Temp() throws JAMSEntity.NoSuchAttributeException {
        int day = this.time.get(6) - 1;
        double LAI_temp = this.LAIArray.getValue()[day];
        double snowcov = this.snowcover.getValue();
        double vegetationcover = this.biomass.getValue();
        double radiation = this.radiat / 1000.0;
        double epsilon_solar = (radiation * 0.8 - 14.0) / 20.0;
        double coverweightveg = vegetationcover / (vegetationcover + Math.exp(7.563 - 1.297E-4 * vegetationcover));
        double coverweightsnow = snowcov / (snowcov + Math.exp(6.055 - 0.3002 * snowcov));
        double coverweight = Math.max(coverweightveg, coverweightsnow);
        double temp_bare_soil = this.calc_Soil_Surface_Temp2();
        this.surfacet = coverweight * this.Soil_Temp + (1.0 - coverweight) * temp_bare_soil;
        this.Surfacetemp.setValue(this.surfacet);
        return this.surfacet;
    }

    private double calc_Soil_Surface_Temp2() throws JAMSEntity.NoSuchAttributeException {
        double temp_min = this.atemp_min.getValue();
        double temp_max = this.atemp_max.getValue();
        double albedofactor = 0.01;
        double temp_bare_soil = (1.0 - albedofactor) * (temp_min + (temp_max - temp_min) * Math.pow(0.03 * this.radiat, 0.5)) + this.surfacet * albedofactor;
        return temp_bare_soil;
    }

    public void cleanup() {
    }
}

