/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KPlantGrowthStress", author="Manfred Fink", description="Calculation of the plant growth stress factor after SWAT")
public class J2KPlantGrowthStress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant growth nitrogen stress factor")
    public JAMSDouble nstrs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant growth temperature stress factor")
    public JAMSDouble tstrs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant growth water stress factor")
    public JAMSDouble wstrs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Biomass sum produced for a given day [kg/ha] drymass")
    public JAMSDouble BioAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Plants daily biomass increase [kg/ha]")
    public JAMSDouble BioOpt_delta;

    public void init() {
    }

    public void run() {
        double stressfactor = 1.0 - Math.max(this.wstrs.getValue(), Math.max(this.tstrs.getValue(), this.nstrs.getValue()));
        if (stressfactor > 1.0) {
            System.out.println("Stress " + stressfactor);
            stressfactor = 1.0;
        }
        if (stressfactor < 0.0) {
            stressfactor = 0.0;
        }
        double bioact = stressfactor * this.BioOpt_delta.getValue() + this.BioAct.getValue();
        this.BioAct.setValue(bioact);
    }

    public void cleanup() {
    }
}

