/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KPlantGrowthNitrogenStress", author="Manfred Fink", description="Calculation of the plant groth nitrogen factor after SWAT")
public class J2KPlantGrowthNitrogenStress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="optimal nitrogen content in Biomass in (kgN/ha)")
    public JAMSDouble optibioN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrogen content in Biomass in (kgN/ha)")
    public JAMSDouble actbioN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="in [-] plant groth nitrogen stress factor")
    public JAMSDouble nstrs;

    public void init() {
    }

    public void run() {
        double run_nstrs = 0.0;
        double run_optibioN = this.optibioN.getValue();
        double run_actbioN = this.actbioN.getValue();
        double phi_nit = 0.0;
        phi_nit = 200.0 * ((run_actbioN + 0.01) / (run_optibioN + 0.01) - 0.5);
        run_nstrs = 1.0 - phi_nit / (phi_nit + Math.exp(3.535 - 0.02597 * phi_nit));
        this.nstrs.setValue(run_nstrs);
    }

    public void cleanup() {
    }
}

