/*
 * Decompiled with CFR 0.152.
 */
package org.jams.j2k.s_n;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KNSoilLayer", author="Manfred Fink", description="Calculates Nitrogen transformation Processes in Soil. Method after SWAT2000")
public class J2KNSoilLayer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area in m\u00c2\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" number of soil layers [-]")
    public JAMSDouble Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil layer")
    public JAMSDoubleArray layerdepth = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in cm depth of soil profile")
    public JAMSDouble totaldepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in m actual depth of roots")
    public JAMSDouble rootdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="in kg/dm\u00c2\u00b3 soil bulk density")
    public JAMSDoubleArray soil_bulk_density = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual LPS in portion of sto_LPS soil water content")
    public JAMSDoubleArray sat_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="actual MPS in portion of sto_MPS soil water content")
    public JAMSDoubleArray sat_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum MPS  in l soil water content")
    public JAMSDoubleArray stohru_MPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum LPS  in l soil water content")
    public JAMSDoubleArray stohru_LPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="maximum FPS  in l soil water content")
    public JAMSDoubleArray stohru_FPS = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="soil temperature in layerdepth in \u00c2\u00b0C")
    public JAMSDoubleArray Soil_Temp_Layer = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" in % organic Carbon in soil")
    public JAMSDoubleArray C_org = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NO3-Pool in kgN/ha")
    public JAMSDoubleArray NO3_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4-Pool in kgN/ha")
    public JAMSDoubleArray NH4_Pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSDoubleArray N_activ_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSDoubleArray N_stabel_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of N-Organic Pool with reactive organic matter in kgN/ha")
    public JAMSDouble sN_activ_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of N-Organic Pool with stable organic matter in kgN/ha")
    public JAMSDouble sN_stabel_pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="sum of NO3-Pool in kgN/ha")
    public JAMSDouble sNO3_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of NH4-Pool in kgN/ha")
    public JAMSDouble sNH4_Pool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of NResiduePool in kgN/ha")
    public JAMSDouble sNResiduePool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of interflowNabs in kgN/ha")
    public JAMSDouble sinterflowNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" sum of interflowN in kgN/ha")
    public JAMSDouble sinterflowN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Residue in Layer in kgN/ha")
    public JAMSDoubleArray Residue_pool = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" N-Organic fresh Pool from Residue in kgN/ha")
    public JAMSDoubleArray N_residue_pool_fresh = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" actual evaporation in mm")
    public JAMSDoubleArray aEP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="mps diffusion between layers value")
    public JAMSDoubleArray w_layer_diff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" surface runoff in l")
    public JAMSDouble RD1_out;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" interflow in l")
    public JAMSDoubleArray RD2_out = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" percolation in l")
    public JAMSDouble D_perco;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" voltalisation rate from NH4_Pool in kgN/ha")
    public JAMSDouble Volati_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" NH4 fertilizer rate in kgN/ha")
    public JAMSDouble NH4inp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" nitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Nitri_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" denitrification rate from  NO3_Pool in kgN/ha")
    public JAMSDouble Denit_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in  in kgN/ha")
    public JAMSDouble SurfaceN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in  in kgN/ha")
    public JAMSDoubleArray InterflowN = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in kgN/ha")
    public JAMSDouble PercoN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff in kgN")
    public JAMSDouble SurfaceNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in in kgN")
    public JAMSDoubleArray InterflowNabs = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in percolation in in kgN")
    public JAMSDouble PercoNabs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in surface runoff added to HRU layer in in kgN")
    public JAMSDouble SurfaceN_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate in interflow in added to HRU layer in kgN")
    public JAMSDoubleArray InterflowN_in = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="potential nitrogen content of plants in kgN/ha")
    public JAMSDouble BioNoptAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrate nitrogen content of plants in kgN/ha")
    public JAMSDouble BioNAct;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual nitrate uptake of plants in kgN/ha")
    public JAMSDouble actnup;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="intfiltration poritions for the single horizonts in l")
    public JAMSDoubleArray infiltration_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="percolation out ouf the single horizonts in l")
    public JAMSDoubleArray perco_hor = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="percolation out ouf the single horizonts in l")
    public JAMSDoubleArray actETP_h = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description=" Nitrate input due to Fertilisation in kgN/ha")
    public JAMSDouble fertNO3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Ammonium input due to Fertilisation in kgN/ha")
    public JAMSDouble fertNH4;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Stable organig N input due to Fertilisation in kgN/ha")
    public JAMSDouble fertstableorg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Activ organig N input due to Fertilisation in kgN/ha")
    public JAMSDouble fertactivorg;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="Sum of N input due fertilisation and deposition in kgN/ha")
    public JAMSDouble sum_Ninput;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current organic fertilizer amount added to residue pool")
    public JAMSDouble fertorgNfresh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description=" Input of plant residues kg/ha")
    public JAMSDouble inp_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Nitrogen input of plant residues in kgN/ha")
    public JAMSDouble inpN_biomass;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate constant between N_activ_pool and N_stabel_pool = 0.00001")
    public JAMSDouble Beta_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between N_activ_pool and NO3_Pool to be calibrated 0.001 - 0.003")
    public JAMSDouble Beta_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" rate factor between Residue_pool and NO3_Pool to be calibrated 0.1 - 0.02")
    public JAMSDouble Beta_rsd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description=" percolation coefitient to calibrate = 0.2")
    public JAMSDouble Beta_NO3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="nitrogen uptake distribution parameter to calibrate = 1 - 15")
    public JAMSDouble Beta_Ndist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="infiltration bypass parameter to calibrate = 0 - 1")
    public JAMSDouble infil_conc_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="denitrfcation saturation factor normally at 0.95 to calibrate 0 - 1")
    public JAMSDouble denitfac;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="concentration of Nitrate in rain = 0 - 0.05 kgN/(mm * ha)")
    public JAMSDouble deposition_factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precipitation in mm")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="indicates dormancy of plants")
    public JAMSBoolean dormancy;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Indicates PIADIN application")
    public JAMSInteger piadin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="time in days since the last PIADIN application")
    public JAMSInteger App_time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Indicates fertilazation optimization with plant demand")
    public JAMSDouble opti;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Mineral nitrogen content in the soil profile down to 60 cm depth")
    public JAMSDouble nmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Indicates whether roots can penetrate or not the soil layer [-]")
    public JAMSDoubleArray root_h = new JAMSDoubleArray();
    private double gamma_temp;
    private double gamma_water;
    private double runarea;
    private double runSoil_Temp_Layer;
    private double[] runlayerdepth;
    private double runsoil_bulk_density;
    private double sto_MPS;
    private double sto_LPS;
    private double sto_FPS;
    private double act_LPS;
    private double act_MPS;
    private double runnetPrecip;
    private double runC_org;
    private double runNO3_Pool;
    private double runNH4_Pool;
    private double runN_activ_pool;
    private double runN_stabel_pool;
    private double runN_residue_pool_fresh;
    private double runResidue_pool;
    private double RD1_out_mm;
    private double RD2_out_mm;
    private double d_perco_mm;
    private double h_perco_mm;
    private double h_infilt_mm;
    private int layer;
    private double runvolati_trans;
    private double runplantupN;
    private double rundenit_trans;
    private double runsurfaceN;
    private double runinterflowN;
    private double runpercoN;
    private double runsurfaceNabs;
    private double runinterflowNabs;
    private double runpercoNabs;
    private double runsurfaceN_in;
    private double runinterflowN_in;
    private double sumlayer;
    private double runBeta_trans;
    private double runBeta_min;
    private double runBeta_rsd;
    private double runBeta_NO3;
    private boolean precalc_nit_vol;
    private double theta_nit = 0.05;
    private double fr_actN = 0.02;
    private double N_nit_vol = 0.0;
    private double frac_nitr = 0.0;
    private double frac_vol = 0.0;
    private double Hum_trans;
    private double Hum_act_min;
    private double runnitri_trans = 0.0;
    private double delta_ntr = 0.0;
    private double concN_mobile = 0.0;
    private int datumjul = 0;
    private int app_time = 0;
    double[] hor_by_infilt;
    double[] NO3_Poolvals;
    double[] w_l_diff;
    double[] partnmin;
    double[] diffout;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int i = 0;
        this.gamma_temp = 0.0;
        this.gamma_water = 0.0;
        this.runarea = this.area.getValue();
        this.app_time = this.App_time.getValue();
        this.layer = (int)this.Layer.getValue();
        double runprecip = this.precip.getValue();
        this.sumlayer = 0.0;
        double runsum_Ninput = 0.0;
        double sumNO3_Pool = 0.0;
        double sumNH4_Pool = 0.0;
        double suminterflowNabs = 0.0;
        double suminterflowN = 0.0;
        double sumN_residue_pool = 0.0;
        double sumN_activ_pool = 0.0;
        double sumN_stabel_pool = 0.0;
        double h_infilt_mm_sum = 0.0;
        double Sumvolati_trans = 0.0;
        double Sumdenit_trans = 0.0;
        double Sumnitri_trans = 0.0;
        double sumh_infilt_mm = 0.0;
        double sum_Nupmove = 0.0;
        double N_upmove_h = 0.0;
        double a_deposition = 0.0;
        double NO3respool = 0.0;
        double Nactiverespool = 0.0;
        double diffoutN = 0.0;
        double runnmin = 0.0;
        this.runlayerdepth = new double[this.layer];
        double[] NH4_Poolvals = new double[this.layer];
        double[] N_activ_poolvals = new double[this.layer];
        double[] N_stabel_poolvals = new double[this.layer];
        double[] N_residue_pool_freshvals = new double[this.layer];
        double[] Residue_poolvals = new double[this.layer];
        double[] interflowNvals = new double[this.layer];
        double[] percoNvals = new double[this.layer];
        double[] interflowNabsvals = new double[this.layer];
        double[] percoNabsvals = new double[this.layer];
        double[] plantup_hor = new double[this.layer];
        double[] NO3balance = new double[this.layer];
        double[] NH4balance = new double[this.layer];
        double[] Nbalance = new double[this.layer];
        double[] NO3_Poolalt = new double[this.layer];
        double[] ConcN_mobile = new double[this.layer];
        this.runsurfaceN = 0.0;
        this.hor_by_infilt = new double[this.layer];
        this.diffout = new double[this.layer];
        this.partnmin = new double[this.layer];
        this.w_l_diff = new double[this.layer];
        i = 0;
        this.NO3_Poolvals = this.calc_plantuptake();
        i = 0;
        double sumplant = 0.0;
        double plantup_h = 0.0;
        for (i = this.layer - 1; i > 0; --i) {
            this.h_infilt_mm = this.infiltration_hor.getValue()[i] / this.runarea;
            this.hor_by_infilt[i - 1] = (sumh_infilt_mm += this.h_infilt_mm) * this.infil_conc_factor.getValue();
        }
        for (i = 0; i < this.layer; ++i) {
            this.diffout[i] = 0.0;
        }
        i = 0;
        for (i = 0; i < this.layer - 1; ++i) {
            this.w_l_diff[i] = this.w_layer_diff.getValue()[i] / this.runarea;
            if (this.w_l_diff[i] > 0.0) {
                this.diffout[i + 1] = this.diffout[i + 1] + this.w_l_diff[i];
                continue;
            }
            this.diffout[i] = this.diffout[i] - this.w_l_diff[i];
        }
        for (i = 0; i < this.layer; ++i) {
            this.runSoil_Temp_Layer = this.Soil_Temp_Layer.getValue()[i];
            this.sto_MPS = this.stohru_MPS.getValue()[i] / this.runarea;
            this.sto_LPS = this.stohru_LPS.getValue()[i] / this.runarea;
            this.sto_FPS = this.stohru_FPS.getValue()[i] / this.runarea;
            this.act_LPS = this.sat_LPS.getValue()[i] * this.sto_LPS;
            this.act_MPS = this.sat_MPS.getValue()[i] * this.sto_MPS;
            this.runC_org = this.C_org.getValue()[i];
            this.runNO3_Pool = this.NO3_Poolvals[i];
            this.runNH4_Pool = this.NH4_Pool.getValue()[i];
            this.runN_activ_pool = this.N_activ_pool.getValue()[i];
            this.runN_stabel_pool = this.N_stabel_pool.getValue()[i];
            this.runN_residue_pool_fresh = this.N_residue_pool_fresh.getValue()[i];
            this.runResidue_pool = this.Residue_pool.getValue()[i];
            this.RD1_out_mm = this.RD1_out.getValue() / this.runarea;
            this.RD2_out_mm = this.RD2_out.getValue()[i] / this.runarea;
            this.d_perco_mm = this.D_perco.getValue() / this.runarea;
            this.h_perco_mm = this.perco_hor.getValue()[i] / this.runarea;
            this.runvolati_trans = 0.0;
            this.rundenit_trans = 0.0;
            this.runinterflowN = 0.0;
            this.runpercoN = 0.0;
            this.runsurfaceN_in = this.SurfaceN_in.getValue() * 10000.0 / this.runarea;
            this.runinterflowN_in = this.InterflowN_in.getValue()[i] * 10000.0 / this.runarea;
            this.SurfaceN_in.setValue(0.0);
            this.runBeta_trans = this.Beta_trans.getValue();
            this.runBeta_min = this.Beta_min.getValue();
            this.runBeta_rsd = this.Beta_rsd.getValue();
            this.runBeta_NO3 = this.Beta_NO3.getValue();
            if (this.fertNH4.getValue() > 0.0 && this.piadin.getValue() == 1) {
                this.app_time = 0;
            }
            ++this.app_time;
            for (int j = 1; j < this.layer; ++j) {
                N_upmove_h = this.calc_nitrateupmove(j);
                sum_Nupmove += N_upmove_h;
            }
            this.gamma_temp = 0.9 * (this.runSoil_Temp_Layer / (this.runSoil_Temp_Layer * Math.exp(9.93 - 0.312 * this.runSoil_Temp_Layer))) + 0.1;
            this.gamma_water = this.sto_LPS + this.sto_MPS + this.sto_FPS > 0.0 ? (this.act_LPS + this.act_MPS + this.sto_FPS) / (this.sto_LPS + this.sto_MPS + this.sto_FPS) : 0.0;
            this.precalc_nit_vol = this.calc_nit_volati(i);
            this.runvolati_trans = this.calc_voltalisation();
            this.runnitri_trans = this.calc_nitrification();
            this.Hum_trans = this.calc_Hum_trans();
            this.runNH4_Pool -= this.runvolati_trans + this.runnitri_trans;
            if (this.runNH4_Pool < 0.0) {
                this.runNH4_Pool = 0.0;
            }
            this.runN_stabel_pool += this.Hum_trans;
            if (this.runN_stabel_pool < 0.0) {
                this.runN_stabel_pool = 0.0;
            }
            this.runN_activ_pool -= this.Hum_trans;
            if (this.runN_activ_pool < 0.0) {
                this.runN_activ_pool = 0.0;
            }
            this.Hum_act_min = this.calc_Hum_act_min();
            this.runN_activ_pool -= this.Hum_act_min;
            if (this.runN_activ_pool < 0.0) {
                this.runN_activ_pool = 0.0;
            }
            if (i < 1) {
                this.runResidue_pool = this.runResidue_pool + this.inp_biomass.getValue() + this.fertorgNfresh.getValue() * 10.0;
                this.runN_residue_pool_fresh = this.runN_residue_pool_fresh + this.inpN_biomass.getValue() + this.fertorgNfresh.getValue();
                this.runNH4_Pool += this.fertNH4.getValue();
                this.delta_ntr = this.calc_Res_N_trans();
                a_deposition = this.deposition_factor.getValue() * runprecip;
                this.runResidue_pool -= this.delta_ntr * this.runResidue_pool;
                if (this.runResidue_pool < 0.0) {
                    this.runResidue_pool = 0.0;
                }
                runsum_Ninput = this.fertactivorg.getValue() + this.fertNH4.getValue() + this.fertNO3.getValue() + this.fertorgNfresh.getValue() + a_deposition;
                this.runN_stabel_pool += this.fertstableorg.getValue();
                Nactiverespool = 0.2 * (this.delta_ntr * this.runN_residue_pool_fresh);
                this.runN_activ_pool = this.runN_activ_pool + this.fertactivorg.getValue() + Nactiverespool;
                if (this.runN_activ_pool < 0.0) {
                    this.runN_activ_pool = 0.0;
                }
                NO3respool = 0.8 * (this.delta_ntr * this.runN_residue_pool_fresh);
                this.runNO3_Pool = this.runNO3_Pool + sum_Nupmove + this.fertNO3.getValue() + a_deposition + this.runnitri_trans + this.Hum_act_min + this.runinterflowN_in + this.runsurfaceN_in + NO3respool;
                this.rundenit_trans = this.calc_denitrification();
                this.runNO3_Pool -= this.rundenit_trans;
                if (this.runNO3_Pool < 0.0) {
                    this.runNO3_Pool = 0.0;
                }
                this.runN_residue_pool_fresh -= this.delta_ntr * this.runN_residue_pool_fresh;
                if (this.runN_residue_pool_fresh < 0.0) {
                    this.runN_residue_pool_fresh = 0.0;
                }
            } else {
                this.runNO3_Pool = this.runNO3_Pool + this.runnitri_trans + this.runinterflowN_in + percoNvals[i - 1] + this.Hum_act_min;
                this.rundenit_trans = this.calc_denitrification();
                this.runNO3_Pool -= this.rundenit_trans;
                if (this.runNO3_Pool < 0.0) {
                    this.runNO3_Pool = 0.0;
                }
            }
            ConcN_mobile[i] = this.concN_mobile = this.calc_concN_mobile(i);
            if (i == 0) {
                this.runsurfaceN = this.calc_surfaceN();
                this.runNO3_Pool -= this.runsurfaceN;
            }
            this.runinterflowN = this.calc_interflowN(i);
            this.runNO3_Pool -= this.runinterflowN;
            this.runpercoN = this.calc_percoN(i);
            this.runNO3_Pool -= this.runpercoN;
            if (this.runNO3_Pool < 0.0) {
                this.runNO3_Pool = 0.0;
            }
            this.runinterflowNabs = this.runinterflowN * this.runarea / 10000.0;
            this.runpercoNabs = this.runpercoN * this.runarea / 10000.0;
            this.NO3_Poolvals[i] = this.runNO3_Pool;
            NH4_Poolvals[i] = this.runNH4_Pool;
            N_activ_poolvals[i] = this.runN_activ_pool;
            N_stabel_poolvals[i] = this.runN_stabel_pool;
            N_residue_pool_freshvals[i] = this.runN_residue_pool_fresh;
            Residue_poolvals[i] = this.runResidue_pool;
            interflowNvals[i] = this.runinterflowN;
            interflowNabsvals[i] = this.runinterflowNabs;
            percoNvals[i] = this.runpercoN;
            percoNabsvals[i] = this.runpercoNabs;
            sumN_stabel_pool = this.runN_stabel_pool + sumN_stabel_pool;
            sumN_activ_pool = this.runN_activ_pool + sumN_activ_pool;
            sumNH4_Pool = this.runNH4_Pool + sumNH4_Pool;
            sumN_residue_pool += this.runN_residue_pool_fresh;
            if (i < 5) {
                sumNO3_Pool = this.runNO3_Pool + sumNO3_Pool;
            }
            suminterflowNabs = this.runinterflowNabs + suminterflowNabs;
            suminterflowN = this.runinterflowN + suminterflowN;
            Sumvolati_trans += this.runvolati_trans;
            Sumdenit_trans += this.rundenit_trans;
            Sumnitri_trans += this.runnitri_trans;
        }
        i = 0;
        for (i = 0; i < this.layer - 1; ++i) {
            if (this.w_l_diff[i] < 0.0) {
                diffoutN = this.w_l_diff[i] * ConcN_mobile[i];
                this.NO3_Poolvals[i] = this.NO3_Poolvals[i] + diffoutN;
                this.NO3_Poolvals[i + 1] = this.NO3_Poolvals[i + 1] - diffoutN;
            } else {
                diffoutN = this.w_l_diff[i] * ConcN_mobile[i + 1];
                this.NO3_Poolvals[i] = this.NO3_Poolvals[i] + diffoutN;
                this.NO3_Poolvals[i + 1] = this.NO3_Poolvals[i + 1] - diffoutN;
            }
            if (this.opti.getValue() != 1.0) continue;
            runnmin = (this.NO3_Poolvals[i] + NH4_Poolvals[i]) * this.partnmin[i] + runnmin;
        }
        double[] zerosetter = new double[this.layer];
        for (i = 0; i < this.layer; ++i) {
            zerosetter[i] = 0.0;
        }
        this.NO3_Pool.setValue(this.NO3_Poolvals);
        this.NH4_Pool.setValue(NH4_Poolvals);
        this.N_activ_pool.setValue(N_activ_poolvals);
        this.N_stabel_pool.setValue(N_stabel_poolvals);
        this.N_residue_pool_fresh.setValue(N_residue_pool_freshvals);
        this.Residue_pool.setValue(Residue_poolvals);
        this.InterflowN.setValue(interflowNvals);
        this.InterflowNabs.setValue(interflowNabsvals);
        this.PercoN.setValue(percoNvals[this.layer - 1]);
        this.PercoNabs.setValue(percoNabsvals[this.layer - 1]);
        this.SurfaceN.setValue(this.runsurfaceN);
        this.runsurfaceNabs = this.runsurfaceN * this.runarea / 10000.0;
        this.SurfaceNabs.setValue(this.runsurfaceNabs);
        this.sum_Ninput.setValue(runsum_Ninput);
        this.sinterflowNabs.setValue(suminterflowNabs);
        this.sinterflowN.setValue(suminterflowN);
        this.Volati_trans.setValue(Sumvolati_trans);
        this.Denit_trans.setValue(Sumdenit_trans);
        this.Nitri_trans.setValue(Sumnitri_trans);
        this.sN_stabel_pool.setValue(sumN_stabel_pool);
        this.sN_activ_pool.setValue(sumN_activ_pool);
        this.sNH4_Pool.setValue(sumNH4_Pool);
        this.sNO3_Pool.setValue(sumNO3_Pool);
        this.sNResiduePool.setValue(sumN_residue_pool);
        this.App_time.setValue(this.app_time);
        this.InterflowN_in.setValue(zerosetter);
        this.nmin.setValue(runnmin);
    }

    private double[] calc_plantuptake() {
        double upNO3_Pool = 0.0;
        double runrootdepth = this.rootdepth.getValue() * 100.0;
        double[] partroot = new double[this.layer];
        if (this.BioNoptAct.getValue() == 0.0) {
            this.BioNAct.setValue(0.0);
        }
        double runpotN_up = this.BioNoptAct.getValue() - this.BioNAct.getValue();
        if (this.dormancy.getValue()) {
            runpotN_up = 0.0;
        }
        if (runpotN_up < 0.0) {
            runpotN_up = 0.0;
        }
        double[] NO3_Poolvals1 = new double[this.layer];
        double[] potN_up_z = new double[this.layer];
        double[] demandN_up_z = new double[this.layer];
        double rootlayer = 0.0;
        double runBeta_Ndist = this.Beta_Ndist.getValue();
        double demand3 = 0.0;
        double demand2 = 0.0;
        double demand1 = 0.0;
        double uptake1 = 0.0;
        int ii = 0;
        boolean jj = false;
        int j = 0;
        NO3_Poolvals1 = this.NO3_Pool.getValue();
        for (int i = 0; i < this.layer; ++i) {
            this.sumlayer += this.layerdepth.getValue()[i];
            this.runlayerdepth[i] = this.sumlayer;
            if (runrootdepth > this.runlayerdepth[0]) {
                if (runrootdepth > this.runlayerdepth[i]) {
                    partroot[i] = 1.0;
                    rootlayer = i;
                } else if (runrootdepth > this.runlayerdepth[i - 1]) {
                    partroot[i] = (runrootdepth - this.runlayerdepth[i - 1]) / (this.runlayerdepth[i] - this.runlayerdepth[i - 1]);
                    rootlayer = i;
                } else {
                    partroot[i] = 0.0;
                }
            } else if (i == 0) {
                partroot[i] = runrootdepth / this.runlayerdepth[0];
                rootlayer = i;
            }
            if (this.opti.getValue() != 1.0) continue;
            double Nmin_depth = 60.0;
            if (Nmin_depth > this.runlayerdepth[0]) {
                if (Nmin_depth > this.runlayerdepth[i]) {
                    this.partnmin[i] = 1.0;
                    continue;
                }
                if (Nmin_depth > this.runlayerdepth[i - 1]) {
                    this.partnmin[i] = (Nmin_depth - this.runlayerdepth[i - 1]) / (this.runlayerdepth[i] - this.runlayerdepth[i - 1]);
                    continue;
                }
                this.partnmin[i] = 0.0;
                continue;
            }
            if (i != 0) continue;
            this.partnmin[i] = Nmin_depth / this.runlayerdepth[0];
        }
        while ((double)j <= rootlayer) {
            upNO3_Pool = this.NO3_Pool.getValue()[j];
            if (j == 0) {
                potN_up_z[j] = runpotN_up / (1.0 - Math.exp(-runBeta_Ndist)) * (1.0 - Math.exp(-runBeta_Ndist * (this.runlayerdepth[j] / runrootdepth)));
                if (this.runlayerdepth[j] > runrootdepth) {
                    potN_up_z[j] = runpotN_up;
                }
                demand1 = upNO3_Pool - potN_up_z[j];
                uptake1 = potN_up_z[j];
            } else if (j > 0 && (double)j < rootlayer) {
                potN_up_z[j] = runpotN_up / (1.0 - Math.exp(-runBeta_Ndist)) * (1.0 - Math.exp(-runBeta_Ndist * (this.runlayerdepth[j] / runrootdepth))) - uptake1;
                demand1 = upNO3_Pool - potN_up_z[j];
                uptake1 += potN_up_z[j];
            } else if ((double)j == rootlayer) {
                potN_up_z[j] = runpotN_up / (1.0 - Math.exp(-runBeta_Ndist)) * (1.0 - Math.exp(-runBeta_Ndist)) - uptake1;
                demand1 = upNO3_Pool * partroot[j] - potN_up_z[j];
                uptake1 += potN_up_z[j];
            }
            if (demand1 >= 0.0) {
                demandN_up_z[j] = 0.0;
                upNO3_Pool -= potN_up_z[j];
            } else {
                demandN_up_z[j] = upNO3_Pool - potN_up_z[j];
                upNO3_Pool = 0.0;
            }
            NO3_Poolvals1[j] = upNO3_Pool;
            ++j;
        }
        while ((double)ii <= rootlayer) {
            demand2 = demandN_up_z[ii] + demand2;
            ++ii;
        }
        double runactN_up = runpotN_up + demand2;
        double bioNact = 0.0;
        bioNact = this.BioNAct.getValue() + runactN_up;
        this.actnup.setValue(runactN_up);
        this.BioNAct.setValue(bioNact);
        return NO3_Poolvals1;
    }

    private boolean calc_nit_volati(int i) {
        double eta_water = 0.0;
        double eta_temp = 0.0;
        double eta_volz = 0.0;
        double eta_nitri = 0.0;
        double eta_volati = 0.0;
        eta_temp = 0.41 * ((this.runSoil_Temp_Layer - 5.0) / 10.0);
        if (this.act_LPS + this.act_MPS < 0.25 * (this.sto_LPS + this.sto_MPS)) {
            eta_water = (this.act_LPS + this.act_MPS + this.sto_FPS) / (0.25 * (this.sto_LPS + this.sto_MPS + this.sto_FPS));
        } else if (this.act_LPS + this.act_MPS >= 0.25 * (this.sto_LPS + this.sto_MPS)) {
            eta_water = 1.0;
        }
        eta_volz = 1.0 - this.runlayerdepth[i] / (this.runlayerdepth[i] + Math.exp(4.706 - 0.305 * this.runlayerdepth[i] / 20.0));
        eta_nitri = eta_water * eta_temp;
        eta_volati = eta_temp * eta_volz;
        if (this.piadin.getValue() == 1) {
            eta_nitri = eta_nitri / 2000.0 * (double)this.app_time;
        }
        this.N_nit_vol = this.runNH4_Pool * (1.0 - Math.exp(-eta_nitri - eta_volati));
        this.frac_nitr = 1.0 - Math.exp(-eta_nitri);
        this.frac_vol = 1.0 - Math.exp(-eta_volati);
        return true;
    }

    private double calc_Hum_trans() {
        double N_Hum_trans = 0.0;
        N_Hum_trans = this.runBeta_trans * (this.runN_activ_pool * (1.0 / this.fr_actN - 1.0) - this.runN_stabel_pool);
        return N_Hum_trans;
    }

    private double calc_Hum_act_min() {
        double N_Hum_act_min = 0.0;
        N_Hum_act_min = this.runBeta_min * Math.sqrt(this.gamma_temp * this.gamma_water) * this.runN_activ_pool;
        return N_Hum_act_min;
    }

    private double calc_Res_N_trans() {
        double epsilon_C_N = 0.0;
        double gamma_ntr = 0.0;
        epsilon_C_N = this.runResidue_pool * 0.58 / (this.runN_residue_pool_fresh + this.runNO3_Pool);
        gamma_ntr = Math.min(1.0, Math.exp(-0.693 * ((epsilon_C_N - 25.0) / 25.0)));
        this.delta_ntr = this.runBeta_rsd * gamma_ntr * Math.sqrt(this.gamma_temp * this.gamma_water);
        return this.delta_ntr;
    }

    private double calc_nitrification() {
        double nitri_trans = 0.0;
        if (this.runSoil_Temp_Layer > 5.0) {
            nitri_trans = this.frac_nitr / (this.frac_nitr + this.frac_vol) * this.N_nit_vol;
        } else if (this.runSoil_Temp_Layer <= 5.0) {
            nitri_trans = 0.0;
        }
        return nitri_trans;
    }

    private double calc_voltalisation() {
        double volati_trans = 0.0;
        if (this.runSoil_Temp_Layer > 5.0) {
            volati_trans = this.frac_vol / (this.frac_nitr + this.frac_vol) * this.N_nit_vol;
        } else if (this.runSoil_Temp_Layer <= 5.0) {
            volati_trans = 0.0;
        }
        return volati_trans;
    }

    private double calc_denitrification() {
        double denit_trans = 0.0;
        if (this.gamma_water > this.denitfac.getValue()) {
            denit_trans = this.runNO3_Pool * (1.0 - Math.exp(-1.4 * this.gamma_temp * this.runC_org));
            denit_trans = Math.min(denit_trans, 1.0);
        } else if (this.gamma_water <= this.denitfac.getValue()) {
            denit_trans = 0.0;
        }
        return denit_trans;
    }

    private double calc_nitrateupmove(int j) {
        double n_upmove = 0.0;
        double runaEvap = this.aEP_h.getValue()[j];
        double sto_MPS = this.stohru_MPS.getValue()[j];
        double sto_LPS = this.stohru_LPS.getValue()[j];
        double sto_FPS = this.stohru_FPS.getValue()[j];
        double act_LPS = this.sat_LPS.getValue()[j] * sto_LPS;
        double act_MPS = this.sat_MPS.getValue()[j] * sto_MPS;
        n_upmove = 0.1 * this.NO3_Poolvals[j] * (runaEvap / (act_LPS + act_MPS + sto_FPS));
        this.NO3_Poolvals[j] = this.NO3_Poolvals[j] - n_upmove;
        return n_upmove;
    }

    private double calc_concN_mobile(int i) {
        double concN_mobile = 0.0;
        double concN_temp = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (i == 0) {
            mobilewater = this.RD1_out_mm * this.runBeta_NO3 + this.RD2_out_mm + this.h_perco_mm + this.hor_by_infilt[i] + this.diffout[i] + 1.0E-10;
        } else if (i > 0) {
            mobilewater = this.RD2_out_mm + this.h_perco_mm + this.hor_by_infilt[i] + this.diffout[i] + 1.0E-10;
        }
        if (i == this.layer - 1) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + this.diffout[i] + 1.0E-10;
        }
        if ((concN_mobile = (concN_temp = this.runNO3_Pool * (1.0 - Math.exp(-mobilewater / ((1.0 - this.theta_nit) * soilstorage)))) / mobilewater) < 0.0) {
            concN_mobile = 0.0;
        }
        return concN_mobile;
    }

    private double calc_concN_mobile2() {
        double concN_mobile = 0.0;
        double concN_temp = 0.0;
        double mobilewater = 0.0;
        double soilstorage = 0.0;
        soilstorage = this.sto_LPS + this.sto_MPS + this.sto_FPS;
        if (this.layer == 0) {
            mobilewater = this.RD1_out_mm + this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        } else if (this.layer > 0) {
            mobilewater = this.RD2_out_mm + this.d_perco_mm + 1.0E-10;
        }
        concN_mobile = this.runNO3_Pool / (mobilewater + (1.0 - this.theta_nit) * soilstorage);
        if (concN_mobile < 0.0) {
            concN_mobile = 0.0;
        }
        return concN_mobile;
    }

    private double calc_surfaceN() {
        double surfaceN = 0.0;
        surfaceN = this.runBeta_NO3 * this.RD1_out_mm * this.concN_mobile;
        surfaceN = Math.min(surfaceN, this.runNO3_Pool);
        return surfaceN;
    }

    private double calc_interflowN(int i) {
        double interflowN = 0.0;
        interflowN = this.RD2_out_mm * this.concN_mobile;
        interflowN = Math.min(interflowN, this.runNO3_Pool);
        return interflowN;
    }

    private double calc_percoN(int i) {
        double percoN = 0.0;
        percoN = i < this.layer - 1 ? (this.hor_by_infilt[i] + this.h_perco_mm) * this.concN_mobile : this.d_perco_mm * this.concN_mobile;
        percoN = Math.min(percoN, this.runNO3_Pool);
        return percoN;
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

