/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.physicalCalculations;

import org.unijena.jams.data.JAMSCalendar;

public class HourlySolarRadiationCalculationMethods {
    public static double calc_midTimeHourAngle(JAMSCalendar time, int julDay, double longSite, double longTZ, boolean debug) {
        long hour = time.get(11);
        long minute = time.get(12);
        double decMin = minute / 60L;
        double decTime = (double)hour + decMin;
        if (decTime >= 24.0) {
            decTime -= 24.0;
        }
        double midTime = decTime + 0.5;
        double b = Math.PI * 2 * (double)(julDay - 81) / 364.0;
        double Sc = 0.1645 * Math.sin(2.0 * b) - 0.1255 * Math.cos(b) - 0.025 * Math.sin(b);
        double midTimeHourAngle = 0.2617993877991494 * (midTime + 0.06667 * (longTZ - longSite) + Sc - 12.0);
        if (debug) {
            System.out.println("midTime: " + midTime + "\n" + "decTime: " + decTime + "\n" + "b: " + b + "\n" + "Sc: " + Sc + "\n" + "midTimeHourAngle: " + midTimeHourAngle);
        }
        return midTimeHourAngle;
    }

    public static double calc_startTimeHourAngle(double midTimeHourAngle) {
        double startTimeHourAngle = midTimeHourAngle - 0.1308996938995747;
        return startTimeHourAngle;
    }

    public static double calc_endTimeHourAngle(double midTimeHourAngle) {
        double endTimeHourAngle = midTimeHourAngle + 0.1308996938995747;
        return endTimeHourAngle;
    }

    public static double calc_HourlyExtraterrestrialRadiation(double Gsc, double relDist, double w1, double w2, double radLat, double decl) {
        double Ra = 229.1831180523293 * Gsc * relDist * ((w2 - w1) * Math.sin(radLat) * Math.sin(decl) + Math.cos(radLat) * Math.cos(decl) * (Math.sin(w2) - Math.sin(w1)));
        if (Ra < 0.0) {
            Ra = 0.0;
        }
        return Ra;
    }

    public static double calc_HourlyMaxSunshine(double Ra) {
        double N = Ra > 0.0 ? 1.0 : 0.0;
        return N;
    }

    public static double calc_HourlyNetLongwaveRadiation(double tmean, double ea, double Rs, double Rs0, double Rs_Rs0_t0, boolean debug) {
        double relGlobRad = 0.0;
        double tabs = tmean + 273.16;
        double BOLTZMANN = 2.043E-10;
        relGlobRad = Rs0 > 0.0 ? Rs / Rs0 : Rs_Rs0_t0;
        double Rnl = 2.043E-10 * Math.pow(tabs, 4.0) * (0.34 - 0.14 * Math.sqrt(ea)) * (1.35 * relGlobRad - 0.35);
        if (debug) {
            System.out.println("Tmean: " + tmean + "\n" + "ea: " + ea + "\n" + "Rs: " + Rs + "\n" + "Rs0: " + Rs0 + "\n" + "B: " + 2.043E-10 + "\n" + "Rnl: " + Rnl);
        }
        return Rnl;
    }

    public static double calc_SoilHeatFlux(double Rn, double N) {
        double G = N > 0.0 ? 0.1 : 0.5 * Rn;
        return G;
    }

    public static double calc_SlopeAspectCorrectionFactor(double sun_elevation_angle, double azimut, double slope, double aspect) {
        double SACF;
        if (aspect >= 0.0) {
            double asp = 180.0 - aspect;
            double sintheta = Math.sin(sun_elevation_angle) * Math.cos(slope) + Math.cos(sun_elevation_angle) * Math.cos(asp - azimut) * Math.sin(slope);
            SACF = sintheta / Math.sin(sun_elevation_angle);
        } else {
            SACF = 1.0;
        }
        return SACF;
    }
}

