/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class StandardGroundwaterParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Hydrogeology parameter file name")
    public JAMSString gwFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        JAMSEntityCollection gwTypes = new JAMSEntityCollection();
        gwTypes.setEntities(J2KFunctions.readParas(this.dirName.getValue() + "/" + this.gwFileName.getValue(), this.getModel()));
        HashMap<Double, JAMSEntity> gwMap = new HashMap<Double, JAMSEntity>();
        for (JAMSEntity gw : gwTypes.getEntities()) {
            gwMap.put(gw.getDouble("GID"), gw);
        }
        for (JAMSEntity e : this.hrus.getEntities()) {
            JAMSEntity gw;
            gw = (JAMSEntity)gwMap.get(e.getDouble("hgeoID"));
            e.setObject("hgeoType", (Object)gw);
            Object[] attrs = gw.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = gw.getObject((String)attrs[i]);
                if (o instanceof JAMSString) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Groundwater parameter file processed ...", 2);
    }
}

