/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SoilWaterBalance", author="Peter Krause", description="Calculates a simplified soil water balance for each HRU")
public class SoilWaterBalance
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute slope")
    public JAMSDouble slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute id")
    public JAMSDouble id;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute maximum MPS")
    public JAMSDouble maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var actual MPS")
    public JAMSDouble actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU state var relative saturation of MPS")
    public JAMSDouble satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="HRU excess storage")
    public JAMSDouble excStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="direct runoff")
    public JAMSDouble dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="groundwater recharge")
    public JAMSDouble gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="total runoff")
    public JAMSDouble totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="potential ET")
    public JAMSDouble potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="actual ET")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="precipitation")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="snow melt")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="lateral-vertical distribution coefficient")
    public JAMSDouble latVertDist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="lateral recession constant")
    public JAMSDouble recConst;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="ET reduction factor")
    public JAMSDouble linETRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum excStor")
    public JAMSDouble maxExcStor;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double maxMPS;
        double deltaMPS;
        double k_factor = 1.0;
        double maxExcStor = 100000.0;
        if (this.recConst.getValue() != 0.0) {
            k_factor = this.recConst.getValue();
        }
        if (this.maxExcStor.getValue() != 0.0) {
            maxExcStor = this.maxExcStor.getValue() * this.area.getValue();
        }
        double excStor = this.excStor.getValue();
        double actMPS = this.actMPS.getValue();
        double inflow = this.precip.getValue() + this.snowMelt.getValue();
        if (inflow <= (deltaMPS = (maxMPS = this.maxMPS.getValue()) - actMPS)) {
            actMPS += inflow;
            inflow = 0.0;
        } else {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        }
        double actET = this.actET.getValue();
        double potET = this.potET.getValue();
        double deltaET = potET - actET;
        if (inflow >= deltaET) {
            actET = potET;
            inflow -= deltaET;
            deltaET = 0.0;
        } else {
            actET += inflow;
            inflow = 0.0;
            deltaET = potET - actET;
        }
        double linRed = this.linETRed.getValue();
        double reduceET = 1.0;
        if (actMPS < linRed * maxMPS) {
            reduceET = actMPS / (linRed * maxMPS);
        }
        if (actMPS >= (deltaET *= reduceET)) {
            actET += deltaET;
            actMPS -= deltaET;
            deltaET = 0.0;
        } else {
            actET += actMPS;
            actMPS = 0.0;
        }
        deltaMPS = maxMPS - actMPS;
        if (inflow <= deltaMPS) {
            actMPS += inflow;
            inflow = 0.0;
        } else {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        }
        double dirQ = 0.0;
        double gwRecharge = 0.0;
        double slope_weight = Math.tan(this.slope.getValue() * (Math.PI / 180)) * this.latVertDist.getValue();
        if (slope_weight > 1.0) {
            slope_weight = 1.0;
        }
        if ((excStor += inflow * slope_weight) > maxExcStor) {
            dirQ = excStor - maxExcStor;
            excStor = maxExcStor;
        }
        double interflow = excStor * (1.0 / k_factor);
        excStor -= interflow;
        dirQ += interflow;
        gwRecharge = inflow * (1.0 - slope_weight);
        this.actET.setValue(actET);
        this.actMPS.setValue(actMPS);
        this.satMPS.setValue(actMPS / maxMPS);
        this.excStor.setValue(excStor);
        this.gwRecharge.setValue(gwRecharge);
        this.dirQ.setValue(dirQ);
        this.totQ.setValue(dirQ + gwRecharge);
    }

    public void cleanup() {
    }
}

