/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.hydronet;

import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.unijena.hydronet.ActivationFunction;
import org.unijena.hydronet.GenericFunction;

public class Neuron {
    protected double sizeOfArea;
    protected double activation;
    protected double delta;
    protected double lastInput;
    protected double input;
    protected long ID;
    protected Vector ActivationFunctions = new Vector();

    public Neuron() {
        this.initalize();
    }

    public void setID(long ID) {
        this.ID = ID;
    }

    public void initalize() {
        this.activation = 0.0;
        this.delta = 0.0;
        this.lastInput = 0.0;
        this.ID = 0L;
    }

    public void reset() {
        this.activation = 0.0;
        this.input = 0.0;
        this.delta = 0.0;
    }

    public void addToInput(double value) {
        this.input += value;
    }

    public void setSizeOfArea(double sizeOfArea) {
        this.sizeOfArea = sizeOfArea;
    }

    public double getSizeOfArea() {
        return this.sizeOfArea;
    }

    public void addFilter(GenericFunction af) {
        this.ActivationFunctions.add(af);
    }

    public int getNumberOfFilters() {
        return this.ActivationFunctions.size();
    }

    public GenericFunction getFilter(int i) {
        return (GenericFunction)this.ActivationFunctions.get(i);
    }

    protected double calc(double value) {
        this.activation = 0.0;
        Enumeration e = this.ActivationFunctions.elements();
        while (e.hasMoreElements()) {
            GenericFunction gc = (GenericFunction)e.nextElement();
            ActivationFunction af = gc.getFunction();
            this.activation += af.calculate(value);
        }
        return this.activation;
    }

    protected double calcDelta(double value, double error, double buffer) {
        this.delta = 0.0;
        Enumeration e = this.ActivationFunctions.elements();
        while (e.hasMoreElements()) {
            GenericFunction gc = (GenericFunction)e.nextElement();
            ActivationFunction af = gc.getDFunction();
            this.delta += af.calculate(value) * error * buffer;
        }
        return this.delta;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public void setActivation(double input) {
        this.activation = input;
        this.lastInput = input;
    }

    public double getActivation() {
        return this.activation;
    }

    public void resetFunctions() {
        this.ActivationFunctions.clear();
    }

    public double getInput() {
        return this.input;
    }

    public void writeData(FileWriter f) {
    }
}

